/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include <unistd.h>

#include "orxonox_gui.h"
#include "orxonox_gui_video.h"
#include "orxonox_gui_audio.h"
#include "orxonox_gui_exec.h"
#include "orxonox_gui_flags.h"
#include "orxonox_gui_banner.h"
#include "orxonox_gui_keys.h"
#include "orxonox_gui_update.h"

  Window* orxonoxGUI;
  OrxonoxGuiVideo* video;
  OrxonoxGuiAudio* audio;
  OrxonoxGuiExec* exec;
  OrxonoxGuiFlags* flags;
  OrxonoxGuiBanner* banner;
  OrxonoxGuiKeys* keys;
  OrxonoxGuiUpdate* update;
int verbose = 4;

int main(int argc, char *argv[])
{
  OrxonoxGui* orxonoxgui = new OrxonoxGui(argc, argv);
  return 0;
}

/* ORXONOXGUI */

/**
   \brief Initializes the Gui
*/
OrxonoxGui::OrxonoxGui(int argc, char *argv[])
{
  initGUI(argc, argv);

  orxonoxGUI = new Window( "grafical orxonox loader, "PACKAGE_VERSION);
  
  Box* windowBox = new Box ('h');

  banner = new OrxonoxGuiBanner();
  windowBox->fill (banner->getWidget());
  
  Box* optionBox = new Box('v');
  
  Box* avBox = new Box('h');

  video = new OrxonoxGuiVideo();
  avBox->fill(video->getWidget());
  audio = new OrxonoxGuiAudio();
  avBox->fill(audio->getWidget());
      
  optionBox->fill(avBox);

  keys = new OrxonoxGuiKeys();
  optionBox->fill(keys->getWidget());

  exec = new OrxonoxGuiExec();
  optionBox->fill(exec->getWidget());

  flags = new OrxonoxGuiFlags();

  optionBox->fill(flags->getWidget());
  windowBox->fill(optionBox);

  update = new OrxonoxGuiUpdate();
  optionBox->fill(update->getWidget());
  
  orxonoxGUI->fill(windowBox);

  // Reading Values from File
  exec->setFilename("~/.orxonox.conf");
  exec->readFromFile(orxonoxGUI);
  // Merging changes to the Options from appended flags.
  for (int optCount = 1; optCount < argc; optCount++)
    orxonoxGUI->walkThrough(Widget::flagCheck, argv[optCount], 0);

  flags->setTextFromFlags(orxonoxGUI);
  orxonoxGUI->showall();

  //// Handling special Cases. ///

  // case update //
#ifdef HAVE_CURL
  if (static_cast<Option*>(orxonoxGUI->findWidgetByName("auto update", 0))->value == 1)
    {
      update->checkForUpdates();
    }
#endif /* HAVE_CURL */

  // case start-with-gui.
  if (!access(exec->getConfigFile(), F_OK) && static_cast<Option*>(orxonoxGUI->findWidgetByName("Always Show this Menu", 0))->value == 0)
    OrxonoxGuiExec::startOrxonox(NULL, exec);
  else
    {
      mainloopGUI();
    }

}


/**
   \brief Destructor.
*/
OrxonoxGui::~OrxonoxGui(void)
{
  delete video;
  delete audio;
  delete exec;
  delete flags;
  delete banner;
  delete keys;
  delete update;
}
