/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer:
*/


#include "orxonox_console_log.h"

GtkWidget* OrxonoxConsoleLog::createLog()
{
  frame = gtk_frame_new ("Console Log:");
  {
    scrollframe = gtk_scrolled_window_new (NULL, NULL);
    logtext = new char;
    
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollframe),
				    GTK_POLICY_AUTOMATIC,
				    GTK_POLICY_AUTOMATIC);
    
    gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrollframe),
					 GTK_SHADOW_IN);
    gtk_container_set_border_width (GTK_CONTAINER(scrollframe), 5);
    
    logView = gtk_text_view_new();
    gtk_text_view_set_editable(GTK_TEXT_VIEW(logView), FALSE);
    log = gtk_text_view_get_buffer (GTK_TEXT_VIEW (logView));
    gtk_container_add(GTK_CONTAINER(scrollframe), logView);
    gtk_container_add(GTK_CONTAINER(frame),scrollframe);
    gtk_text_buffer_set_text (log, "Orxonox Console started.\n", -1);

  }
  return (frame);
}

void OrxonoxConsoleLog::appendText(char* append)
{
  GtkTextIter iter;
  if (verbose>=1)
    printf ("appending: %s\n", append);
  strcat (append,"\n");
  gtk_text_buffer_get_start_iter (log, &iter);
  gtk_text_buffer_place_cursor (log, &iter);
  gtk_text_buffer_insert_at_cursor (log, append, -1);
  return;
}

void OrxonoxConsoleLog::clear()
{
  sprintf(logtext, "");
  return;
}
