/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer:
*/


#include "orxonox_console.h"

using namespace std;

void OrxonoxConsole::createWindow ()
{
  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);
  gtk_window_set_title ( GTK_WINDOW (window), "orxonox console");
  g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (gtk_main_quit), NULL);
  g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (gtk_main_quit), NULL);
  gtk_container_set_border_width (GTK_CONTAINER (window), 5);

  vbox_main = gtk_vbox_new(FALSE, 5);
    {
      gtk_box_pack_start(GTK_BOX(vbox_main), entry.createEntry(), FALSE, FALSE, 0);
      gtk_box_pack_start(GTK_BOX(vbox_main), log.createLog(), TRUE, TRUE, 0);
      entry.setLog(&log);
    }
  gtk_container_add(GTK_CONTAINER(window), vbox_main);
  
  gtk_widget_show_all(window);

}




int main( int argc, char *argv[] )
{  
  verbose = 0;

  OrxonoxConsole console;
  
  gtk_init (&argc, &argv);

  console.createWindow();

  gtk_main ();
  return (0);
}
