/*!
  \file windowHandler.h
  \brief contains the WindowHandler class for the minimal display system
*/


#ifndef _WINDOWHANDLER_H
#define _WINDOWHANDLER_H

extern int verbose;

#include "stdincl.h"

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#ifdef __WIN32__
#include <windows.h>
#endif /* __WIN32__ */

#define TRUE 1     //!< define true
#define FALSE 0    //!< define false
#define BOOL int   //!< define BOOL

//! A simple class to handle a minimal display system
class WindowHandler
{
  public:
    WindowHandler() { };
    ~WindowHandler() { };
    GLvoid KillGLWindow(GLvoid);
    BOOL CreateGLWindow(char* title, int width, int height, int bits, BOOL fullscreenflag);
    SDL_Surface* screen;   //!< The screen to which to display the rendered stuff
  private:
    int InitGL(GLvoid);
    void ReSizeGLScene(GLsizei width, GLsizei height);  
};


#endif
