/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "windowHandler.h"
#include <stdio.h>

/**
   \brief Resizes the Window
   \param width the new size in the width.
   \param height the new size in the height.
*/
void WindowHandler::ReSizeGLScene(GLsizei width, GLsizei height) // Resize And Initialize The GL Window
{
	if (height==0)	// Prevent A Divide By Zero By
	{
		height=1;// Making Height Equal One
	}

	glViewport(0,0,width,height); // Reset The Current Viewport

	
	glMatrixMode(GL_PROJECTION); // Select The Projection Matrix
	glLoadIdentity();	


	// Calculate The Aspect Ratio Of The Window
	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);
	gluLookAt (0,0,15, 0,0,0, 0,1,0);

	glMatrixMode(GL_MODELVIEW); // Select The Modelview Matrix
	glLoadIdentity(); // Reset The Modelview Matrix

}

/**
   \brief initializes openGL
*/
int WindowHandler::InitGL(GLvoid)										// All Setup For OpenGL Goes Here
{
	glEnable(GL_TEXTURE_2D); // Enable Texture Mapping
	glShadeModel(GL_SMOOTH); // Enable Smooth Shading
	glClearColor(0.00f, 0.00f, 0.00f, 0.0f); // Black Background
	glClearDepth(1.0f);  // Depth Buffer Setup
	glEnable(GL_DEPTH_TEST); // Enables Depth Testing
	glDepthFunc(GL_LEQUAL);	// The Type Of Depth Testing To Do
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);  // Really Nice Perspective Calculations

    return TRUE;
}

/**
   \brief kills the window
*/
GLvoid WindowHandler::KillGLWindow(GLvoid) // Properly Kill The Window
{
	SDL_Quit();
}

/**
   \brief creates a new Window for the scene
   \param title the name of the Window
   \param width the width of the window
   \param height the height of the window
   \param bits the bits per pixel to use
   \param fullscreenflag TRUE if fullscreen FALSE if windowed/
   \returns FALSE if initialisation failed, TRUE otherwise
*/
BOOL WindowHandler::CreateGLWindow(char* title, int width, int height, int bits, BOOL fullscreenflag)
{
	Uint32 flags;
	int size;

	/* Initialize SDL */
	if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
		fprintf(stderr, "Couldn't init SDL: %s\n", SDL_GetError());
		return FALSE;
	}

	flags = SDL_OPENGL;
	if ( fullscreenflag ) {
		flags |= SDL_FULLSCREEN;
	}
	SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 1 );
	if ( (screen = SDL_SetVideoMode(width, height, 0, flags)) == NULL ) {
		return FALSE;
	}
	SDL_GL_GetAttribute( SDL_GL_STENCIL_SIZE, &size);

	ReSizeGLScene(width, height); // Set Up Our Perspective GL Screen

	if (!InitGL()) // Initialize Our Newly Created GL Window
	{
	  KillGLWindow();  // Reset The Display
	  return FALSE;
	}

	return TRUE;
}


