/*!
  \file objModel.h
  \brief Contains the OBJ-model Class, that reads in a Model from a .obj-file
*/

#ifndef _OBJMODEL_H
#define _OBJMODEL_H

#include "model.h"

//! A Class, that handles the parsing of an obj-file, and inclusion as a Model.
class OBJModel : public Model
{
 public:
  OBJModel(char* fileName);
  OBJModel(char* fileName, float scaling);
  virtual ~OBJModel();
  void initializeOBJ(void);

 private:
  // Variables
  char* objPath;        //!< The Path where the obj and mtl-file are located.
  char* objFileName;    //!< The Name of the obj-file.
  char* mtlFileName;    //!< The Name of the mtl-file (parsed out of the obj-file)

  ///// readin /////
  bool importFile (char* fileName);
  bool readFromObjFile (void);
  bool readMtlLib (char* matFile);

};

#endif /* _OBJ_MODEL_H */
