/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "framework.h"

#include "vector.h"

int verbose;
void DrawGLScene()
{
  currFrame = SDL_GetTicks();
  dt = currFrame - lastFrame; 
  if (dt == 0)
    dist += (zoomTo-dist)/500;
  else 
    dist += (zoomTo-dist)/500 *(float)dt;

  rotatorP += rotatorV *(float)dt;
  

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
  glLoadIdentity(); // Reset the view
  
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();	
  gluPerspective(45.0f,500/375,0.1f,dist * 5.0f);
    gluLookAt (0, dist , dist, 0,0,0, up.x,up.y,up.z);

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  //  glRotatef (180, dir.x, dir.y, dir.z);
  glMultMatrixf (*matQ);
  if (obj)
    obj->draw();

  glPopMatrix();

  SDL_GL_SwapBuffers(); // Swap the buffers
  lastFrame = currFrame;
}


int main(int argc, char *argv[])
{
  verbose = 3;

  Uint8* keys; // This variable will be used in the keyboard routine
  int done=FALSE; // We aren't done yet, are we?

  // Create a new OpenGL window with the title "Cone3D Basecode" at
  // 640x480x32, fullscreen and check for errors along the way
  if(wHandler.CreateGLWindow("Whandler Basecode", 800, 600, 32, FALSE) == FALSE)
  {
    // If an error is found, display a message, kill the GL and SDL screens (if they were created) and exit
    PRINTF(1)("Could not initalize OpenGL :(\n\n");
    wHandler.KillGLWindow();
    return 0;
  }
  
  PRINTF(2)("screensize: %i, %i\n", wHandler.screen->w, wHandler.screen->h);
  if (argc>=3)
    obj = new OBJModel (argv[1], atof(argv[2]));
  else if (argc>=2)
    obj = new OBJModel(argv[1]);
  else 
    {
      // This is an example, of how it is possible, to create a new Model, and adding some vertex-information.
      // This also packs everything into a DisplayList, and can be handled exactly as any other model.
      // This is an example of a cube with Texture-Coordinates, but without explicite Vertex-Normals. (they are soft-created).
      /*
      obj = (OBJModel*) new Model();
      obj->setName("CUBE");
      obj->addVertex (-0.5, -0.5, 0.5);
      obj->addVertex (0.5, -0.5, 0.5);
      obj->addVertex (-0.5, 0.5, 0.5);
      obj->addVertex (0.5, 0.5, 0.5);
      obj->addVertex (-0.5, 0.5, -0.5);
      obj->addVertex (0.5, 0.5, -0.5);
      obj->addVertex (-0.5, -0.5, -0.5);
      obj->addVertex (0.5, -0.5, -0.5);
      
      obj->addVertexTexture (0.0, 0.0);
      obj->addVertexTexture (1.0, 0.0);
      obj->addVertexTexture (0.0, 1.0);
      obj->addVertexTexture (1.0, 1.0);
      obj->addVertexTexture (0.0, 2.0);
      obj->addVertexTexture (1.0, 2.0);
      obj->addVertexTexture (0.0, 3.0);
      obj->addVertexTexture (1.0, 3.0);
      obj->addVertexTexture (0.0, 4.0);
      obj->addVertexTexture (1.0, 4.0);
      obj->addVertexTexture (2.0, 0.0);
      obj->addVertexTexture (2.0, 1.0);
      obj->addVertexTexture (-1.0, 0.0);
      obj->addVertexTexture (-1.0, 1.0);

      obj->addFace ("1 2 4 3");
      obj->addFace ("3 4 6 5");
      obj->addFace ("5 6 8 7");
      obj->addFace ("7 8 2 1");
      obj->addFace ("2 8 6 4");
      obj->addFace ("7 1 3 5");
      obj->finalize();
      */
      obj = (OBJModel*) new Model(CYLINDER);
    }
  M = Vector(wHandler.screen->w/2, wHandler.screen->h/2, 0); 
  rotAxis = Vector (0.0,1.0,0.0);
  rotAngle = 0;

  matQ[0][0] = matQ[1][1] = matQ[2][2] = matQ[3][3] = 1;
  rotQ = Quaternion (rotAngle, rotAxis);
  rotQlast = rotQ;
  dir = Vector (0.0, 0.0, 1.0);
  up = Vector (0.0, 1.0, 0.0);

  glEnable(GL_LIGHTING);
  glEnable(GL_DEPTH_TEST);

  GLfloat whiteLight[] = {1.0, 1.0, 1.0,1.0};
  GLfloat light0Position[] = {10.0, 10.0, 10.0, 0.0};
  GLfloat light1Position[] = {-10.0, -7.0, -6.0, 0.0};
  GLfloat lmodelAmbient[] = {.1, .1, .1, 1.0};

  glEnable(GL_LIGHT0);
  glLightfv(GL_LIGHT0, GL_POSITION, light0Position);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, whiteLight);
  glLightfv(GL_LIGHT0, GL_SPECULAR, whiteLight);
  
  glEnable(GL_LIGHT1);
  glLightfv(GL_LIGHT1, GL_POSITION, light1Position);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, whiteLight);
  glLightfv(GL_LIGHT1, GL_SPECULAR, whiteLight);
  

  glEnable(GL_TEXTURE_2D);
  rotatorP = .0;
  rotatorV = .0;
  dist = 5.0;
  zoomTo = dist;
  // Build the font from a TGA image font.tga in the data directory
  // Hide the mouse cursor
    SDL_ShowCursor(2);
    mouse1Down = false;

  // This is the main loop for the entire program and it will run until done==TRUE
  while(!done)
  {
    // Draw the scene
    DrawGLScene();
    // And poll for events
    SDL_Event event;
    while ( SDL_PollEvent(&event) ) {
      switch (event.type) {
      case SDL_MOUSEMOTION:
	PRINTF(3)("Mouse motion about %d,%d Pixels to (%d,%d).\n", 
		  event.motion.xrel, event.motion.yrel,
		  event.motion.x, event.motion.y);
	// TRACKBALL
	if (mouse1Down)
	  {
	    int mX = event.button.x;
	    int mY = event.button.y;
	    int wH = wHandler.screen->h;
	    int wW = wHandler.screen->w;
	    Vector tmpV (mX, mY, sqrt ( (float) abs(wH * wH/4 - (wW/2-mX) * (wW/2-mX) - (wH/2-mY) * (wH/2-mY)) ));
	    //	    PRINTF(0)("tmpV: %f, %f, %f\n", tmpV.x, tmpV.y, tmpV.z);
	    p2 = tmpV-M;
	    p2.y = -p2.y;
	    rotAxis = p1.cross(p2);
	    //  PRINTF(0)("rotAxis: %f, %f, %f\n", rotAxis.x, rotAxis.y, rotAxis.z);

	    // in case that there is no rotation-axis defined
	    if (rotAxis.x != 0 || rotAxis.y != 0 || rotAxis.z != 0)
	      {
		rotAxis.normalize();
		//		PRINTF(0)("rotAxis: %f, %f, %f\n", rotAxis.x, rotAxis.y, rotAxis.z, rotAngle);
				
		rotAngle = angleRad (p1, p2);
		rotQ = Quaternion (rotAngle, rotAxis);
		rotQ = rotQ * rotQlast;
		rotQ.matrix (matQ);
		//	dir = rotQ.apply(dir);
		//      dir.normalize();
		//	PRINTF(0)("rotAxis: %f, %f, %f, %f\n", dir.x, dir.y, dir.z, rotAngle);
	      }
	    rotQlast = rotQ;
	    p1 = p2;

	  }
	break;
      case SDL_MOUSEBUTTONDOWN:
	if (event.button.button == 4)
	  {
	    PRINTF(0)("MouseWheel up\n");
	    zoomTo *= .5;
	  }
	else if (event.button.button == 5)
	  {
	    PRINTF(2)("MouseWheel down\n");
	    zoomTo *= 2.0;
	  }
	else if (event.button.button == 1)
	  {
	    mouse1Down = true;
	    int mX = event.button.x;
	    int mY = event.button.y;
	    int wH = wHandler.screen->h;
	    int wW = wHandler.screen->w;
	    Vector tmpV (mX, mY, sqrt ( (float) abs(wH * wH/4 - (wW/2-mX) * (wW/2-mX) - (wH/2-mY) * (wH/2-mY)) ));
	    p1 = tmpV-M;
	    p1.y = -p1.y;

	  }
	else
	  {
	    PRINTF(0)("MouseButton %d pressed at (%d,%d).\n",
		   event.button.button, event.button.x, event.button.y);
	    rotatorV = ( (float)wHandler.screen->w/2 -event.button.x) / (float)wHandler.screen->w / 100.0;
	  }
	    
	break;
      case SDL_MOUSEBUTTONUP:
	if (event.button.button == 4);
	else if (event.button.button == 5);
	else if (event.button.button == 1)
	  mouse1Down =false;
	else 
	    {
	      PRINTF(2)("MouseButton %d released at (%d,%d).\n",
			event.button.button, event.button.x, event.button.y);
	    }
	break;


      case SDL_KEYDOWN:
	switch (event.key.keysym.sym)
	  {
	  case SDLK_x:
	    delete obj;
	    obj = NULL;
	    break;
	  case SDLK_c:
	    if (!obj)
	      obj = new OBJModel(argv[1]);
	    break;
	  case SDLK_a:
	    zoomTo /=2;
	    break;
	  case SDLK_z:
	    zoomTo *=2;

	  }
	break;
	    
        // If a quit event was recieved
      case SDL_QUIT:
	// then we're done and we'll end this program
          done=TRUE;
          break;
      default:
          break;
      }


    }

    // Get the state of the keyboard keys
    keys = SDL_GetKeyState(NULL);

    // and check if ESCAPE has been pressed. If so then quit
    if(keys[SDLK_ESCAPE]) done=TRUE;
  }

  // Kill the GL & SDL screens
  if (obj)
    delete obj;
  wHandler.KillGLWindow();
  // And quit
  return 0;
}
