/*!
  \file array.h
  \brief Contains the Array Class that handles float arrays.
  this class creates a Array of a semi-Dynamic length.
  beware, that after finalizing the array may not be resized again.
*/

#ifndef _ARRAY_H
#define _ARRAY_H

extern int verbose; //!< will be obsolete soon

#include "stdincl.h"

//! Array Class that handles dynamic-float arrays.
class Array
{
 public:
  Array ();
  ~Array();

  void initializeArray ();
  void finalizeArray (void);
  void addEntry (GLfloat entry);
  void addEntry(GLfloat entry0, GLfloat entry1, GLfloat entry2);
  
  GLfloat* getArray ();
  int getCount();
  void debug(void);
 private:
  //! One entry of the Array
  struct Entry
  {
    GLfloat value;  //!< The value of this Entry.
    Entry* next;    //!< Pointer to the Next entry.
  };

  GLfloat* array;      //!< The array that will be produced when finalizing the Array.
  int entryCount;      //!< The count of Entries in this Array.
  bool finalized;      //!< If this variable is set to true, the Array can not be changed anymore. true if finalized, false else (initially).
  Entry* firstEntry;   //!< Pointer to the first Entry of this Array
  Entry* currentEntry; //!< Pointer to the current Entry of this Array. The one Entry we are working with.
  
  
};

#endif
