/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "array.h"

/**
   \brief creates a new Array
*/
Array::Array ()
{
  this->initializeArray ();
}

/**
   \brief deletes an Array.
   It does this by first deleting all the array-entries, and then delete the array[] itself
*/
Array::~Array()
{
  PRINTF(2)("deleting array\n");
  Entry* walker = this->firstEntry;
  Entry* previous;
  while (walker)
    {
      previous = walker;
      walker = walker->next;
      delete previous;
    }
  if (finalized)
    delete []this->array;
}

/**
   \brief initializes an Array
   the Function does this by setting up a fistEntry, and setting the entryCount.
*/
void Array::initializeArray ()
{
  PRINTF(2)("crating new Array\n");
  this->firstEntry = new Entry;
  this->firstEntry->next =NULL;
  this->currentEntry=firstEntry;
  this->finalized = false;
  this->entryCount = 0; //0 means one entry
  return;
}

/**
   \brief finalizes an array.
   This Function creates the array, and makes it ready to be sent to the application.
*/
void Array::finalizeArray (void)
{
  PRINTF(3)("Finalizing array. Length: %i\n", entryCount);  
  //  if ((array = (GLfloat*)malloc( entryCount* sizeof(GLfloat))) == NULL)
  if (!(this->array = new GLfloat [this->entryCount]))
    PRINTF(1)("could not allocate %i data Blocks\n", this->entryCount);
  Entry* walker = this->firstEntry;
  for (int i=0; i<this->entryCount; i++)
    {
      this->array[i] = walker->value;
      walker = walker->next;
    }
  this->finalized = true;

  return;
}

/**
   \brief adds a new Entry to the Array
   \param entry Entry to add.
*/
void Array::addEntry (GLfloat entry)
{
  if (!this->finalized)
    {
      PRINTF(3)("adding new Entry to Array: %f\n", entry);
      
      this->currentEntry->value = entry;
      this->currentEntry->next = new Entry;
      this->currentEntry = currentEntry->next;
      this->currentEntry->next = NULL;
      ++this->entryCount;
    }
  else 
    PRINTF(1)("adding failed, because list has been finalized\n");
}

/**
   \brief Adds 3 entries at once (convenience)
*/
void Array::addEntry (GLfloat entry0, GLfloat entry1, GLfloat entry2)
{
  this->addEntry (entry0);
  this->addEntry (entry1);
  this->addEntry (entry2);
}
  
/**
   \brief Gives back the array !! MUST be executed AFTER finalize.
   \returns The created array.
*/
GLfloat* Array::getArray ()
{
  return this->array;
}

/**
   \returns The Count of entries in the Array
*/
int Array::getCount()
{
  return this->entryCount;
}

/**
   \brief Simple debug info about the Array
*/
void Array::debug ()
{
  PRINTF(0)("entryCount=%i, address=%p\n", this->entryCount, this->array);
}
