/*! 
    \file glfont.h
    \brief Handles the display of glFonts.
*/

#ifndef _GLFONT_H
#define _GLFONT_H

#include "../glincl.h"

class GLFont
{
 public:
  GLFont();
  GLFont(const char* fontFile);
  ~GLFont();
  


  bool setFont(const char* fontFile);
  void setText(const char* text);

  void setStyle(char* style);
  void setSize(void);
  void setPosition(int x, int y);
  
  void renderText(void);
  void renderText(const char* text, int x, int y);

 private:
  char* fontFile;
  char* text;
  GLuint texture;
  int positionX;
  int positionY;
  int renderStyle;
  SDL_Surface* surface;
  GLfloat* texcoord;

  bool init(const char* fontFile);
  bool loadTexture();
  static int powerOfTwo(int input);

  static bool ttfInitialized;

};

#endif /* _GLFONT_H */
