

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/


#include "null_parent.h"


using namespace std;

NullParent* NullParent::singletonRef = 0;

NullParent* NullParent::getInstance ()
{
  if( singletonRef == NULL)
    singletonRef = new NullParent ();
  return singletonRef;
}

/**
   \brief standard constructor

   \todo this constructor is not jet implemented - do it
*/
NullParent::NullParent () 
{
  this->parent = this;
  this->mode = ALL;
}


NullParent::NullParent (Vector* absCoordinate)
{
  this->parent = this;
  this->mode = ALL;
  this->absCoordinate = *absCoordinate;
}


/**
   \brief standard deconstructor

   \todo this deconstructor is not jet implemented - do it
*/
NullParent::~NullParent () 
{
  delete singletonRef;
  singletonRef = NULL;
}




/**
   \brief updates the absCoordinate/absDirection

   this is used to go through the parent-tree to update all the absolute coordinates
   and directions. this update should be done by the engine, so you don't have to 
   worry, normaly...
*/
void NullParent::update (float timeStamp)
{
  this->absCoordinate = this->relCoordinate;
  this->absDirection = parent->getAbsDir () * this->relDirection;
  
  PNode* pn = this->children->enumerate ();
  while( pn != NULL) 
    { 
      /* if this node has changed, make sure, that all children are updated also */
      if( this->bRelCoorChanged || this->bAbsCoorChanged)
	pn->parentCoorChanged ();
      if( this->bRelDirChanged || this->bAbsDirChanged)
	pn->parentDirChanged ();
      pn->update (timeStamp);
      pn = this->children->nextElement ();
    }

  this->timeStamp = timeStamp;
  this->bRelCoorChanged = false;
  this->bAbsCoorChanged = false;
  this->bRelDirChanged = false;
  this->bAbsDirChanged = false;
}
