/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*! 
    \file debug.h
    \brief Handles output to console for different Verbose-Modes.
*/ 

#ifndef _DEBUG_H
#define _DEBUG_H

#define NO              0
#define ERR             1
#define WARN            2
#define INFO            3
#define DEBUGING        4

#if HAVE_CONFIG_H 
#include <config.h> 
#endif

#include <stdio.h>

///////////////////////////////////////////////////
/// PRINTF: prints with filename and linenumber ///
///////////////////////////////////////////////////

#ifdef DEBUG
extern int verbose;
#define PRINTF(x) \
           PRINTF ## x

#if DEBUG >= ERR
#define PRINTF1 \
    if (verbose >= ERR) \
      printf("%s:%d::ERROR:", __FILE__, __LINE__) && printf
#else 
#define PRINTF1 if (NO)
#endif
     
#if DEBUG >= WARN
#define PRINTF2 \
     if (verbose >= WARN) \
       printf("%s:%d::WARNING:", __FILE__, __LINE__) && printf
         
#else 
#define PRINTF2 if (NO)
#endif
     
#if DEBUG >= INFO
#define PRINTF3 \
     if (verbose >= INFO) \
       printf("%s:%d::INFO:", __FILE__, __LINE__) && printf
#else 
#define PRINTF3 if (NO)
#endif
     
#if DEBUG >= DEBUGING
#define PRINTF4 \
     if (verbose >= DEBUGING) \
       printf("%s:%d::DEBUG:", __FILE__, __LINE__) && printf
#else 
#define PRINTF4 if (NO)
#endif
     
     
#else  
#define PRINTF(x) if (NO)
#endif

#define PRINTF0 \
    printf("%s:%d::", __FILE__, __LINE__) && printf


///////////////////////////////////////////////////
///  PRINT: just prints output as is            ///
///////////////////////////////////////////////////
#ifdef  DEBUG
extern int verbose;
#define PRINT(x) \
  PRINT ## x

#if DEBUG >= ERR
#define PRINT1	\
  if (verbose >= ERR)	\
    printf
#else 
#define PRINT1 if (NO)
#endif

#if DEBUG >= WARN
#define PRINT2 \
  if (verbose >= WARN) \
    printf

#else 
#define PRINT2 if (NO)
#endif

#if DEBUG >= INFO
#define PRINT3 \
  if (verbose >= INFO) \
    printf
#else 
#define PRINT3 if (NO)
#endif

#if DEBUG >= DEBUGING
#define PRINT4 \
  if (verbose >= DEBUGING) \
    printf
#else 
#define PRINT4 if (NO)
#endif


#else  
#define PRINT(x) if (NO)
#endif

#define PRINT0 \
  printf

///////////////////////////////////////////////////
/// COUT: simple cout print with verbose-check  ///
///////////////////////////////////////////////////
#ifdef  DEBUG
#define COUT(x) \
           COUT ## x

#if DEBUG >= 1
#define COUT1 \
    if (verbose >= 1 ) \
      cout
#else 
#define COUT1 if (NO) cout
#endif
     
#if DEBUG >= 2
#define COUT2 \
     if (verbose >= 2 ) \
       cout

#else 
#define COUT2 if (NO) cout
#endif
     
#if DEBUG >= 3
#define COUT3 \
     if (verbose >= 3 ) \
       cout
#else
#define COUT3 if (NO) cout
#endif
     
#if DEBUG >= 4
#define COUT4 \
     if (verbose >= 4 ) \
       cout
#else 
#define COUT4 if (NO) cout
#endif
     
     
#else  
#define COUT(x) if (NO) cout
#endif

#define COUT0 \
           cout

#endif /* _DEBUG_H */
