/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/


#include "orxonox_gui_video.h"

/**
   \brief Creates the Video-Option-Frame
*/
OrxonoxGuiVideo::OrxonoxGuiVideo(void)
{
  this->videoFrame = new Frame("Video-Options:");
  this->videoBox = new Box('v');
  this->videoFrame->setGroupName("video");
  
  this->fullscreen = new CheckButton("Fullscreen-mode");
  this->fullscreen->setFlagName("windowed", "q", 1);
  this->fullscreen->saveability();
  this->videoBox->fill(this->fullscreen);
  this->resolution = new Menu("Resolution", "640x480", "800x600", "1024x768", "1280x1024", "1400x1050", "1600x1200", "1920x1200", "lastItem");
  this->resolution->saveability();
  this->videoBox->fill(this->resolution);
  this->wireframe = new CheckButton("WireFrame-mode");
  this->wireframe->setFlagName("wireframe", "w", 0);
  this->wireframe->saveability();
  this->videoBox->fill(this->wireframe);

  this->advancedWindowCreate();
  this->videoBox->fill(this->advancedWindowGetButton());

  this->videoFrame->fill(videoBox);
}

/**
   \brief Destructs the Video-stuff
*/
OrxonoxGuiVideo::~OrxonoxGuiVideo(void)
{
  // nothing to do here.
}

/**
   \return Returns the Video-frame
*/
Widget* OrxonoxGuiVideo::getWidget(void)
{
  return this->videoFrame;
}


/**
   \brief Creates a window, and all it contains for the Source-update.
*/
void OrxonoxGuiVideo::advancedWindowCreate(void)
{
  // the button, that opens this Window.
  this->advancedButton = new Button("advanced");

  // the Window itself
  this->advancedWindow = new Window("Advanced Video Options");
  this->advancedWindow->setGroupName("advancedVideoOptions");

  this->advancedBox = new Box('v');

  // Advanced Performance Options
  this->shadows = new CheckButton("Shadows");
  this->shadows->saveability();
  this->advancedBox->fill(this->shadows);

  this->fog = new CheckButton("Fog");
  this->fog->saveability();
  this->advancedBox->fill(this->fog);

  this->reflections = new CheckButton("Reflections");
  this->reflections->saveability();
  this->advancedBox->fill(this->reflections);

  this->textures = new CheckButton("Textures");
  this->textures->saveability();
  this->advancedBox->fill(this->textures);

  this->textureDetail = new Menu("Texture Detail", "low", "medium", "high", "lastItem");
  this->textureDetail->saveability();
  this->advancedBox->fill(this->textureDetail);

  this->modelDetailLabel = new Label("Model Detail");
  this->advancedBox->fill(this->modelDetailLabel);
  this->modelDetail = new Menu("Model Detail", "low", "medium", "high", "lastItem");
  this->modelDetail->saveability();
  this->advancedBox->fill(this->modelDetail);

  this->antiAliasingLabel = new Label("Anti-Aliasing-depth:");
  this->advancedBox->fill(this->antiAliasingLabel);
  this->antiAliasing = new Menu("Anti Aliasing", "0", "1", "2", "4", "8",  "lastItem");
  this->antiAliasing->saveability();
  this->advancedBox->fill(this->antiAliasing);

  this->filterMethodLabel = new Label("Filtering Method:");
  this->advancedBox->fill(this->filterMethodLabel);
  this->filterMethod = new Menu("Filtering Method", "none", "linear", "bilinear", "trilinear", "anisortopic", "lastItem");
  this->filterMethod->saveability();
  this->advancedBox->fill(this->filterMethod);
  
  this->closeButton = new Button("close");
  this->advancedBox->fill(this->closeButton);

  this->advancedWindow->fill(advancedBox);
#ifdef HAVE_GTK2 
  this->advancedButton->connectSignal("button_press_event", this->advancedWindow, Window::windowOpen);
  this->closeButton->connectSignal("button_press_event", this->advancedWindow, Window::windowClose);
  this->advancedWindow->connectSignal("destroy", this->advancedWindow, Window::windowClose);
  this->advancedWindow->connectSignal("delete_event", this->advancedWindow, Window::windowClose);
#endif /* HAVE_GTK2 */
   Window::addWindow(this->advancedWindow);

}

/**
   \returns A Pointer to the Button of the UpdaterSourceWindow
*/
Button* OrxonoxGuiVideo::advancedWindowGetButton(void)
{
  return this->advancedButton;
}

