/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include "orxonox_gui_keys.h"

/**
   \brief Creates an Keyboard-Frame
*/
OrxonoxGuiKeys::OrxonoxGuiKeys(void)
{
  this->keysFrame = new Frame("Keyboard-Options:");
  //  keysFrame->setGroupName("Keyboard");
  this->keysBox = new Box('h');
  this->player1 = new Player("player1");
  this->player2 = new Player("player2");

  this->keysBox->fill(this->player1->getOpenButton());
  this->keysBox->fill(this->player2->getOpenButton());

  this->keysFrame->fill(this->keysBox);
}

/**
   \brief Destructs the Keys-stuff
*/
OrxonoxGuiKeys::~OrxonoxGuiKeys(void)
{
  // nothing to do here.
}

/**
   \brief Return the Frame
   \return Returns the Audio-frame
*/
Widget* OrxonoxGuiKeys::getWidget(void)
{
  return this->keysFrame;
}

/* PLAYER */

/**
   \brief Creates new inputs for a player
   \param player the name of the Player
*/
Player::Player(char* player)
{
  char* windowName = new char[strlen(player)+25];
  strcpy(windowName, "Keyboard settings of ");
  strcat(windowName, player);
  this->pKeyWindow = new Window(windowName);
  this->pKeyFrame = new Frame(windowName);
   this->pKeysBox = new Box('v');
   this->pKeysBox->setGroupName(player);
    this->pKeysBox->fill(addKey(UP, "up"));
    this->pKeysBox->fill(addKey(DOWN, "down"));
    this->pKeysBox->fill(addKey(LEFT, "left"));
    this->pKeysBox->fill(addKey(RIGHT, "right"));
    this->pKeysBox->fill(addKey(SHOOT, "shoot"));
    delete windowName;
    closeButton = new Button("close");
#ifdef HAVE_GTK2
    this->closeButton->connectSignal("button_press_event", this->pKeyWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

    this->pKeysBox->fill(this->closeButton);
    this->pKeyFrame->fill(this->pKeysBox);
   this->pKeyWindow->fill(this->pKeyFrame);
   Window::addWindow(this->pKeyWindow);
#ifdef HAVE_GTK2
   this->pKeyWindow->connectSignal("destroy", this->pKeyWindow, Window::windowClose);
   this->pKeyWindow->connectSignal("delete_event", this->pKeyWindow, Window::windowClose);
#endif /* HAVE_GTK2 */

  this->openButton = new Button(player);
#ifdef HAVE_GTK2
  this->openButton->connectSignal("button_press_event", this->pKeyWindow, Window::windowOpen);
#endif /* HAVE_GTK2 */

  this->inputWindow = new Window("inputWindow");

  this->inputButton = new Button("test");
  this->inputWindow->fill(inputButton);
#ifdef HAVE_GTK2
  this->inputWindow->connectSignal("destroy",  Widget::doNothingSignal);
  this->inputWindow->connectSignal("delete_event", Widget::doNothingSignal);
#endif /* HAVE_GTK2 */

}

/**
   \brief adds a new Key.
   \param key the number of the Key
   \param name The name of the new Key.
   \returns A widget that has the Key-Box
*/
Widget* Player::addKey(KEYS key, char* name)
{
  this->inputKey[key] = new InputKey;
  this->inputKey[key]->pKeyBox = new Box();
  this->inputKey[key]->pKeyButton = new Button(name);
  this->inputKey[key]->pKeyOLabel = new OptionLabel(name, name);
  this->inputKey[key]->pKeyOLabel->saveability();

#ifdef HAVE_GTK2
  //inputKey[key]->pKeyButton->connectSignal("key_press_event", inputKey[key]->pKeyButton, key_cb);
  this->inputKey[key]->pKeyButton->connectSignal("button_press_event", this->inputKey[key], inputWindowEvent);
#endif /* HAVE_GTK2 */
  this->inputKey[key]->pKeyBox->fill(this->inputKey[key]->pKeyButton);
  this->inputKey[key]->pKeyBox->fill(this->inputKey[key]->pKeyOLabel);
  return this->inputKey[key]->pKeyBox;
}

/**
   \returns the OpenButton of a Player
*/
Button* Player::getOpenButton(void)
{
  return this->openButton;
}

/**
   \brief sets a new Key(only output)
   \param key the new Key.
*/
void Player::setkey(KEYS key)
{
  cout << "setting up Key: "<< key <<endl;
}

Window* Player::inputWindow = NULL;
Button* Player::inputButton = NULL;
long Player::keySignal = 0;

#ifdef HAVE_GTK2
gint Player::inputWindowEvent(GtkWidget* w, GdkEventKey* event, void* inputKey)
{
  inputButton->setTitle("press a Key");
  keySignal = inputButton->connectSignal("key_press_event", inputKey, key_cb);
  inputWindow->open();
}
  
/**
   \brief Function which gets keystrokes
   \param w the widget that released the Function.
   \param event The event that happened.
   \param Widget the Widget which will be applied.
   \returns Nothing
*/
gint Player::key_cb(GtkWidget* w, GdkEventKey* event, void* inputKey)
{
  InputKey* inputkey =(InputKey*) inputKey;
  char title [20];

  switch(event->keyval) 
    {
    case GDK_Up:
      strcpy(title, "up");
      break;
    case GDK_Down:
      strcpy(title, "down");
      break;
    case GDK_Left:
      strcpy(title, "left");
      break;
    case GDK_Right:
      strcpy(title, "right");
      break;
      
    case GDK_space:
      strcpy(title, "space");
      break;
      
    case 65293:
      strcpy(title, "enter");
      break;
      
      // Special Keys //
    case GDK_Escape:
      strcpy(title, "esc");
      break;
    case GDK_Tab:
      strcpy(title, "tab");
      break;
    case GDK_Shift_L:
      strcpy(title, "l_shift");
      break;
    case GDK_Shift_R:
      strcpy(title, "r_shift");
      break;
    case GDK_Control_L:
      strcpy(title, "l_ctrl");
      break;
    case GDK_Control_R:
      strcpy(title, "r_ctrl");
      break;
    case GDK_Alt_L:
      strcpy(title, "l_alt");
      break;
    case GDK_Alt_R:
      strcpy(title, "r_alt");
      break;
      // FXX KEYS //
    case GDK_F1:
      strcpy(title, "f1");
      break;
    case GDK_F2:
      strcpy(title, "f2");
      break;
    case GDK_F3:
      strcpy(title, "f3");
      break;
    case GDK_F4:
      strcpy(title, "f4");
      break;
    case GDK_F5:
      strcpy(title, "f5");
      break;
    case GDK_F6:
      strcpy(title, "f6");
      break;
    case GDK_F7:
      strcpy(title, "f7");
      break;
    case GDK_F8:
      strcpy(title, "f8");
      break;
    case GDK_F9:
      strcpy(title, "f9");
      break;
    case GDK_F10:
      strcpy(title, "f10");
      break;
    case GDK_F11:
      strcpy(title, "f11");
      break;
    case GDK_F12:
      strcpy(title, "f12");
      break;
      
      
    default:
      char* tmp;
      sprintf(tmp, "%c", event->keyval);
      printf("other key %s \n", tmp);
      strcpy(title, tmp);
      break;
    }

  inputkey->pKeyOLabel->setValue(title);
  inputButton->disconnectSignal(keySignal);
  inputWindow->close();
}
#endif /* HAVE_GTK2 */
