/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...

   ***
   * This file is extended to the needs of the orxonox-project.         *
   * The main difference to the version of Marius is, that textures get *
   * loaded by orxonox Texture-class, and that the comments are set up, *
   * in doxygen style                                                   *
   * the Copyright of the original file is below this copyright, and we *
   * hope not to offend Marius through this.                            *
                                                                      ***

*/

/***************************************************************************
                          cone3dfont.cpp  -  description
                             -------------------
    copyright            : (C) 2001 by Marius Andra aka Cone3D
    email                : marius@hot.ee
    ICQ                  : 43999510
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "fontset.h"
#include <stdarg.h>

#include "../importer/texture.h"

/** 
    \brief initializes a new fontset
*/
FontSet::FontSet()
{
  this->sizex=1.0f;
  this->sizey=1.0f;
  this->font = NULL;
}

/** 
    \brief initializes a new fontset with a texture for the font
    \param fontFile The fontfile to load
*/
FontSet::FontSet(char* fontFile)
{
  this->sizex=1.0f;
  this->sizey=1.0f;
  this->font = NULL;
  
}

/**
   \brief deletes the Fontset by freeing all allocated space
   and then deleting the Texture.
*/
FontSet::~FontSet()
{
  killFont();
  // delete the texture;
  delete font;
}

/**
   \brief sets the size of the font
   \param x the width of the font
   \param y the height of the font
*/
int FontSet::setSize(float x, float y)
{
  sizex=x;
  sizey=y;
  
  return 1;
}

/**
   \brief builds the fontset
   \param file the name of the file to get the fontset from.
*/
int FontSet::buildFont(char *file)
{
  int loop1;
  float cx, cy;
  
  if (!font)
    delete font;
  font = new Texture();
  font->loadImage(file);
  
  base=glGenLists(256);                          // Creating 256 Display Lists
  glBindTexture(GL_TEXTURE_2D, font->getTexture()); // Select Our Font Texture
  for (loop1=0; loop1<256; loop1++)              // Loop Through All 256 Lists
    {
      cx=(float)(loop1%16)/16.0f;                  // X Position Of Current Character
      cy=(float)(loop1/16)/16.0f;                  // Y Position Of Current Character
      
      glNewList(base+loop1,GL_COMPILE);            // Start Building A List
      glBegin(GL_QUADS);                           // Use A Quad For Each Character
      glTexCoord2f(cx,1.0f-cy-0.0625f);          // Texture Coord (Bottom Left)
      glVertex2d(0,16);                          // Vertex Coord (Bottom Left)
      glTexCoord2f(cx+0.0625f,1.0f-cy-0.0625f);  // Texture Coord (Bottom Right)
      glVertex2i(16,16);                         // Vertex Coord (Bottom Right)
      glTexCoord2f(cx+0.0625f,1.0f-cy-0.001f);   // Texture Coord (Top Right)
      glVertex2i(16,0);                          // Vertex Coord (Top Right)
      glTexCoord2f(cx,1.0f-cy-0.001f);           // Texture Coord (Top Left)
      glVertex2i(0,0);                           // Vertex Coord (Top Left)
      glEnd();                                     // Done Building Our Quad (Character)
      glTranslated(12,0,0);                        // Move To The Right Of The Character
      glEndList();                                 // Done Building The Display List
    }                                              // Loop Until All 256 Are Built
  return 1;
}

/**
   \brief deletes the display lists.
*/
int FontSet::killFont(void)                          // Delete The Font From Memory
{
  glDeleteLists(base,256);                       // Delete All 256 Display Lists
  return 1;
}

/**
   \brief prints out some text
   \param x most left coordinate of the text.
   \param y the top coordinate of the text
   \param type Type of text
   \param fmt The text to display
   \param ... more text
*/
int FontSet::printText(int x, int y, char type, char *fmt,...)// Where The Printing Happens
{
  char    text[1024];                            // Holds Our String
  int blendOn,scissorOn,textureOn,lightOn;  // Holds the previous GL settings
  int depthOn,matrixMode,screenStats[4],blendSrc,blendDst;
  char typ=type;

  va_list ap;                                    // Pointer To List Of Arguments

  if (fmt == NULL)                               // If There's No Text
    return 1;                                      // Do Nothing
  
  va_start(ap, fmt);                             // Parses The String For Variables
  vsprintf(text, fmt, ap);                       // And Converts Symbols To Actual Numbers
  va_end(ap);                                    // Results Are Stored In Text
  
  if (type>3)                                     // Did User Choose An Invalid Character Set?
    type=3;                                       // If So, Select Set 2 (Italic)
  
  textureOn = glIsEnabled(GL_TEXTURE_2D); // Were textures enabled?
  depthOn = glIsEnabled(GL_DEPTH_TEST);  // Was GL_DEPTH_TEST enabled?
  lightOn = glIsEnabled(GL_LIGHTING); // Was GL_LIGHTING enabled?
  scissorOn = glIsEnabled(GL_SCISSOR_TEST);  // etc.
  glGetIntegerv(GL_MATRIX_MODE, &matrixMode);
  glGetIntegerv(GL_VIEWPORT, screenStats);
  blendOn= glIsEnabled(GL_BLEND);
  glGetIntegerv(GL_BLEND_SRC, &blendSrc);
  glGetIntegerv(GL_BLEND_DST, &blendDst);
  
  if (depthOn) glDisable(GL_DEPTH_TEST);  // If they were enabled/disabled
  if (!textureOn) glEnable(GL_TEXTURE_2D); // then enable/disable them
  if (!blendOn) glEnable(GL_BLEND);
  if (!scissorOn) glEnable(GL_SCISSOR_TEST);
  if (lightOn) glDisable(GL_LIGHTING);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); // Set the correct blending mode
  
  glMatrixMode(GL_PROJECTION); // and initalize Ortho mode
  glPushMatrix();
  glLoadIdentity();
  glOrtho(0.0f,screenStats[2],screenStats[3],0.0f,-1.0f,1.0f);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glBindTexture(GL_TEXTURE_2D, font->getTexture());

  if(type>1) typ=typ-2;
  glLoadIdentity();
  glTranslated(x,y,0);
  glListBase(base-32+(128*typ));
  glScalef(sizex,sizey,1.0f);
  glCallLists(strlen(text),GL_UNSIGNED_BYTE, text); // Write The Text To The Screen
  
  if(type>1)
    {
      glLoadIdentity();
      glTranslated(x+1,y,0);
      glListBase(base-32+(128*(type-2)));
      glScalef(sizex,sizey,1.0f);
      glCallLists(strlen(text),GL_UNSIGNED_BYTE, text); // Write The Text To The Screen
    }

  glBindTexture(GL_TEXTURE_2D, 0); // Fix everything up
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

  if (depthOn) glEnable(GL_DEPTH_TEST);
  if (!textureOn) glDisable(GL_TEXTURE_2D);
  if (!blendOn) glDisable(GL_BLEND);
  if (!scissorOn) glDisable(GL_SCISSOR_TEST);
  if (lightOn) glEnable(GL_LIGHTING);

  glBlendFunc(blendSrc, blendDst);
  glMatrixMode(matrixMode);

  return 1;
}
