

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/


/*! 
    \file error.h
    \brief A compendium of Error codes used in the program
*/ 


#ifndef _ERROR_H
#define _ERROR_H

// these are the two undefined error nr. Don't use them ...
#define oERROR -1

#define oNOERROR 0

/*!
    \brief Error Definitions:

    Error Classes:
    0xx application framework codes
    1xx graphics codes
    2xx file/FS codes
    3xx network codes
    4xx general codes

    Error Specifier 1:
    x0x action finsished as desired
    x1x initialisation error
    x2x execution error
    x3x uninitialisation error

    Error Specifier 2:
    xx0 no further informations
    xx1 only a warning - feel free to ignore, the program will proceed
    xx2 this could lead unexpected behaviour
    xx3 this is a fatal error - you are invited to quit the program - panic!
*/

typedef struct 
{
  int code;
  char* message;
  char* location;
} ErrorMessage;

#endif /* _ERROR_H */
