

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/

#include <iostream>
#include <GL/glut.h>

#include "ai.h"
#include "data_tank.h"

#include "npc.h"

using namespace std;


NPC::NPC()
  : WorldEntity()
{
  hasDied = 0;
}

NPC::~NPC () {}


void NPC::setPosition(float x, float y, float z)
{
  xCor = x; yCor = y; zCor = z;
}

void NPC::getPosition(float* x, float* y, float* z) 
{
  *x = xCor; 
  *y = yCor; 
  *z = zCor;
}

void NPC::setCollisionRadius(float r) 
{
  collisionRadius = r;
}

float NPC::getCollisionRadius() 
{
  return collisionRadius;
}


void NPC::addAI(AI* ai)
{}

void NPC::paint()
{
  //cout << "WorldEntity::WorldEntity();" << endl;  
  /* fix: died flag approach is very stupid, just to show @ convention */
  if( hasDied == 0 ) {
    glPushMatrix();
    glTranslatef(xCor, yCor, 3.0);
    //glScalef(1.0, 3.0, 1.0);
    glutWireSphere(1.0, 10, 10);
    glPopMatrix();
  }
}

void NPC::drawNPC() 
{

}


/* define the reaction, if the ship is been hit */
int NPC::hit()
{
  die();
  return 0;
}


void NPC::die()
{
  hasDied = 1;
}
