

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "campaign.h"
#include "world.h"
#include "camera.h"
#include "story_entity.h"

using namespace std;


Campaign::Campaign () 
{
  this->entities = new ListTemplate<StoryEntity>();
  this->isInit = false;
}

Campaign::~Campaign () {}


ErrorMessage Campaign::init()
{
  this->isInit = true;
}


ErrorMessage Campaign::start()
{
  this->start(0);
}


ErrorMessage Campaign::start(int storyID = 0)
{
  printf("World::start() - starting new StoryEntity Nr:%i\n", storyID);
  ErrorMessage errorCode;
  if( !this->isInit) return errorCode; 
  if( storyID == WORLD_ID_GAMEEND) return errorCode;
  this->running = true;
  StoryEntity* se = this->getStoryEntity(storyID);
  this->currentEntity = se;
  while( se != NULL && this->running)
    {
      se->displayLoadScreen();
      se->load();
      se->init();
      se->releaseLoadScreen();
      se->start();
      se->destroy();
     
      delete se;

      int nextWorldID = se->getNextStoryID();
      //printf("Campaing::start() - got nextWorldID = %i\n", nextWorldID);
      se = this->getStoryEntity(nextWorldID);
      this->currentEntity = se;
      if( ( nextWorldID == WORLD_ID_GAMEEND) ||( se == NULL) ) 
	{
	  printf("Campaign::start() - quitting campaing story loop\n");
	  if(se != NULL)
	    delete se;
	  return errorCode;
	}
      
    }
}


ErrorMessage Campaign::pause()
{
  if(this->currentEntity != NULL)
    this->isPaused = true;
}


ErrorMessage Campaign::resume()
{
  if(this->currentEntity != NULL)
    this->isPaused = false;
}


ErrorMessage Campaign::stop()
{
  this->running = false;
  if(this->currentEntity != NULL) 
    {
      this->currentEntity->stop();
      //delete this->currentEntity;
      //this->currentEntity = NULL;
    }
}


ErrorMessage Campaign::destroy()
{
  if(this->currentEntity != NULL)
    {
      this->currentEntity->destroy();
      delete this->currentEntity;
      this->currentEntity = NULL;
    }
}


/** 
    \brief adds an game stroy entity to the campaign

    \param se: The entity
    \param storyID: The number that identifies the entity in the campaign. Each ID only used once in a Campaign

    An entity can be a world (playable), a cinematic, a shop, sounds, whatever you
    want to queue up in the campaign.
*/
void Campaign::addEntity(StoryEntity* se, int storyID)
{
  se->setStoryID(storyID);
  this->addEntity(se);
}

void Campaign::addEntity(StoryEntity* se)
{
  this->entities->add(se);
}


void Campaign::removeEntity(int storyID)
{
  this->removeEntity(this->getStoryEntity(storyID));
  
}


void Campaign::removeEntity(StoryEntity* se)
{
  this->entities->remove(se);
}


/*
  \brief this changes to the next level
*/
void Campaign::nextLevel()
{
  printf("Campaign:nextLevel()\n");
  //int nextID = this->currentEntity->getNextStoryID();
  //this->stop();
  //this->start(nextID);
  this->currentEntity->stop();
}

/*
  \brief change to the previous level - not implemented

  this propably useless
*/
void Campaign::previousLevel()
{}


/*
  \brief lookup a entity with a given id
  \param story id to be lookuped
  \returns the entity found or NULL if search ended without match
*/
StoryEntity* Campaign::getStoryEntity(int storyID)
{
  //printf("Campaing::getStoryEntity(%i) - getting next Entity\n", storyID);
  if( storyID == WORLD_ID_GAMEEND)
    return NULL;
  ListTemplate<StoryEntity>* l;
  StoryEntity* entity = NULL;
  l = this->entities->getNext();  
  while( l != NULL) 
    { 
      entity = l->getObject();
      l = l->getNext();
      int id = entity->getStoryID();
      //printf("Campaing::getStoryEntity() - now looping, found entity nr=%i\n", id);
      if(id == storyID)
	{
	  //printf("Campaing::getStoryEntity() - yea, this is what we where looking for: %id\n");
	  return entity;
	}
    }
  return NULL;
}
