/*! 
    \file world.h
    \brief Holds and manages all game data
*/ 

#ifndef _WORLD_H
#define _WORLD_H

#include "stdincl.h"
#include "story_entity.h"


class TrackManager;
class WorldEntity;
class Camera;
class PNode;
class GLMenuImageScreen;
class Skysphere;
class Light;
class FontSet;

//! The game world
/**
   this class initializes everything that should be displayed inside of the current level.
   it is the main driving factor during gameplay.
*/
class World : public StoryEntity {

 public:
  World (char* name);
  World (int worldID);
  virtual ~World ();
  
  virtual ErrorMessage init ();
  virtual ErrorMessage start ();
  virtual ErrorMessage stop ();
  virtual ErrorMessage pause ();
  virtual ErrorMessage resume ();

  virtual void load ();
  virtual void destroy ();

  //static void vertexCallback (GLfloat* vertex);

  void timeSlice (Uint32 deltaT);
  void collide ();
  void draw ();
  void update ();	// maps Locations to Placements
  //void calcCameraPos (Location* loc, Placement* plc);
	
  void unload ();
  bool command (Command* cmd);
  virtual void displayLoadScreen();
  virtual void releaseLoadScreen();
  
  //bool system_command (Command* cmd);
  Camera* getCamera ();

  void spawn (WorldEntity* entity);
  void spawn (WorldEntity* entity, Vector* absCoor, Quaternion* absDir);

  tList<WorldEntity>* entities;//!< A template List of all entities. Every moving thing should be included here, and world automatically updates them.
  
  // base level data
  TrackManager* trackManager;  //!< The reference of the TrackManager that handles the course through the Level.
  Camera* localCamera;         //!< The current Camera


 private:
  Uint32 lastFrame;             //!< last time of frame
  bool bQuitOrxonox;            //!< quit this application
  bool bQuitCurrentGame;        //!< quit only the current game and return to menu
  bool bPause;                  //!< pause mode

  FontSet* testFont;            //!< A test Font. \todo fix this, so it is for real.
  GLMenuImageScreen* glmis;     //!< The Level-Loader Display

  char* worldName;              //!< The name of this World
  int debugWorldNr;             //!< The Debug Nr. needed, if something goes wrong
  GLuint objectList;            //!< temporary: \todo this will be ereased soon
  Skysphere* skySphere;         //!< The Environmental Heaven of orxonox \todo insert this to environment insted
  Light* light;                 //!< The Lights of the Level

  WorldEntity* localPlayer;     //!< The Player, you fly through the level.
 
  PNode* nullParent;            //!< The zero-point, that everything has as its parent.
 
  void mainLoop ();
  void synchronize ();
  void handleInput ();
  void timeSlice ();
  void collision ();
  void display ();
  void debug ();

  void swap (unsigned char &a, unsigned char &b); /* \todo: this function doesn't belong here, this should be part of a image class*/
};

#endif /* _WORLD_H */
