/*! 
    \file fontset.h
    \brief Handles the display of Text.
*/

/**
  This file is extended to the needs of the orxonox-project.
  The main difference to the version of Marius is, that textures get 
  loaded by orxonox Texture-class
*/

class Texture;

//! A class to handle a FontSet.
/**
   A fontset is an entire Alphabet (256 entries) of one font.
   It is made by creating a file containing a matrix with 256
   little pictures in it, displaying the letters of this alphabet.
   Then these letters are projected onto Quads, which can be aranged
   in a sorted order, to display some text

   usage:
   1. initialize the Class by loading the source-font-picture
   2. set the size
   3. write some text with printText
   4. delete the class again.
*/ 
class FontSet
{
 public:
  FontSet();
  FontSet(char *file);
  ~FontSet();
  
  int buildFont(char* fontFile);
  int printText(int x, int y, char type, char *fmt, ...);
  int killFont(void);
  int setSize(float x, float y);
  
 private:
  int base;          //!< Save the glLists here.
  float sizex;       //!< the width of the text.
  float sizey;       //!< the height of the text.
  Texture* font;     //!< texture of the font.

};
