/*! 
    \file player.h
    \brief Implements a basic controllable WorldEntity
*/

#ifndef _PLAYER_H
#define _PLAYER_H

#include "world_entity.h"

class OBJModel;

//! Basic controllable WorldEntity
class Player : public WorldEntity 
{
  friend class World;
  
 public:
  Player(bool isFree = false);
  ~Player();
  
  virtual void postSpawn();
  virtual void tick(float time);
  virtual void hit(WorldEntity* weapon, Vector loc);
  virtual void destroy();
  virtual void collide(WorldEntity* other, Uint32 ownhitflags, Uint32 otherhitflags);
  virtual void command(Command* cmd);
  
  virtual void draw();
  // virtual void getLookat(Location* locbuf);
  
  virtual void leftWorld();
  
 private:
  bool bUp;              //!< up button pressed.
  bool bDown;            //!< down button pressed.
  bool bLeft;            //!< left button pressed.
  bool bRight;           //!< right button pressed.
  bool bAscend;          //!< ascend button pressed.
  bool bDescend;         //!< descend button presses.
  bool bFire;            //!< fire button pressed.

  Vector velocity;       //!< the velocity of the player.
  float travelSpeed;     //!< the current speed of the player (to make soft movement)
  float acceleration;    //!< the acceleration of the player.
  
  void move(float time);
  
};

#endif /* _PLAYER_H */
