/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

/*! 
    \file debug.h
    \brief Handles output to console for different Verbose-Modes.
*/ 

#ifndef _DEBUG_H
#define _DEBUG_H

#define NO              0
#define ERROR           1
#define WARNING         2
#define INFORMATION     3
#define DEBUGING        4

#include <stdio.h>

///////////////////////////////////////////////////
/// PRINTF: prints with filename and linenumber ///
///////////////////////////////////////////////////

#ifdef  DEBUG
extern int verbose;
#define PRINTF(x) \
           PRINTF ## x

#if DEBUG >= ERROR
#define PRINTF1 \
    if (verbose >= ERROR) \
      printf("%s:%d::", __FILE__, __LINE__) && printf
#else 
#define PRINTF1 if (NO)
#endif
     
#if DEBUG >= WARNING
#define PRINTF2 \
     if (verbose >= WARNING) \
       printf("%s:%d::", __FILE__, __LINE__) && printf
         
#else 
#define PRINTF2 if (NO)
#endif
     
#if DEBUG >= INFORMATION
#define PRINTF3 \
     if (verbose >= INFORMATION) \
       printf("%s:%d::", __FILE__, __LINE__) && printf
#else 
#define PRINTF3 if (NO)
#endif
     
#if DEBUG >= DEBUGING
#define PRINTF4 \
     if (verbose >= DEBUGING) \
       printf("%s:%d::", __FILE__, __LINE__) && printf
#else 
#define PRINTF4 if (NO)
#endif
     
     
#else  
#define PRINTF(x) if (NO)
#endif

#define PRINTF0 \
    printf("%s:%d::", __FILE__, __LINE__) && printf


///////////////////////////////////////////////////
///  PRINT: just prints output as is            ///
///////////////////////////////////////////////////
#ifdef  DEBUG
extern int verbose;
#define PRINT(x) \
  PRINT ## x

#if DEBUG >= ERROR
#define PRINT1	\
  if (verbose >= ERROR)	\
    printf
#else 
#define PRINT1 if (NO)
#endif

#if DEBUG >= WARNING
#define PRINT2 \
  if (verbose >= WARNING) \
    printf

#else 
#define PRINT2 if (NO)
#endif

#if DEBUG >= INFORMATION
#define PRINT3 \
  if (verbose >= INFORMATION) \
    printf
#else 
#define PRINT3 if (NO)
#endif

#if DEBUG >= DEBUGING
#define PRINT4 \
  if (verbose >= DEBUGING) \
    printf
#else 
#define PRINT4 if (NO)
#endif


#else  
#define PRINT(x) if (NO)
#endif

#define PRINT0 \
  printf

///////////////////////////////////////////////////
/// COUT: simple cout print with verbose-check  ///
///////////////////////////////////////////////////
#ifdef  DEBUG
#define COUT(x) \
           COUT ## x

#if DEBUG >= 1
#define COUT1 \
    if (verbose >= 1 ) \
      cout
#else 
#define COUT1 if (NO) cout
#endif
     
#if DEBUG >= 2
#define COUT2 \
     if (verbose >= 2 ) \
       cout

#else 
#define COUT2 if (NO) cout
#endif
     
#if DEBUG >= 3
#define COUT3 \
     if (verbose >= 3 ) \
       cout
#else
#define COUT3 if (NO) cout
#endif
     
#if DEBUG >= 4
#define COUT4 \
     if (verbose >= 4 ) \
       cout
#else 
#define COUT4 if (NO) cout
#endif
     
     
#else  
#define COUT(x) if (NO) cout
#endif

#define COUT0 \
           cout

#endif /* _DEBUG_H */
