/*!
  \file orxonox_gui_banner.h
  \brief  File that holds the class that creates the Banner-Image.\n
  This is Commercial :-)
*/

#ifndef _ORXONOX_GUI_BANNER_H
#define _ORXONOX_GUI_BANNER_H

#include "orxonox_gui.h"

//! Class that creates the Banner-Image
class OrxonoxGuiBanner
{
 private:
  // the banner Frame
  Frame* bannerFrame;
  Box* bannerBox;
  EventBox* bannerEventBox; //!< an Image needs an EventBox to catch klicks
  Image* bannerImage;
  Label* bannerLabel;

  // the logo Window
  Window* logoWindow;
  EventBox* logoEventBox;
  Box* logoBox;
  Image* logoImage;
  Label* logoLabel;

 public:
  OrxonoxGuiBanner ();
  ~OrxonoxGuiBanner ();

  Widget* getWidget ();

  static gint LogoWindowOpen (GtkWidget *widget, GdkEvent* event, void* banner);
  static gint LogoWindowClose (GtkWidget *widget, GdkEvent* event, void* banner);
};


#endif /* _ORXONOX_GUI_BANNER_H */
