/*! 
    \file curve.h
    \brief A basic 3D curve framework
    
    Contains classes to handle curves
*/ 

#ifndef _CURVE_H
#define _CURVE_H

#include "vector.h"



class Curve
{
 protected:
  int nodeCount;
  Vector curvePoint;

  struct PathNode
  {
    int number;
    Vector position;
    PathNode* next;
  };

  PathNode* firstNode; 
  PathNode* currentNode; 

 public:

  void addNode (const Vector& newNode);

};

//! Bezier Curve
/**
   Class to handle bezier curves in 3-dimesnsional space
   
   needed for  the Tracking system in OrxOnoX.
*/
class BezierCurve : public Curve
{
 private:
  // all from Curve-Class
 public:
  BezierCurve (void);
  ~BezierCurve (void);
  virtual Vector calcPos (float t);
  virtual Vector calcDir (float t);
  
  Vector getPos () const;
};

int ncr(int n, int i);


#endif /* _CURVE_H */
