/*! 
    \file track.h
    \brief Basic level architecture
*/ 

#ifndef TRACK_H
#define TRACK_H

#include "stdincl.h"

//!	The Red Line through a level
/**
   Handles level boundaries, bound movement mapping, camera placement and scripting.
   To create special levels with special camera movement, rules or whatever, derive from this base class.
*/
class Track 
{
 private:
  Uint32 ID;
  Vector* offset;
  Vector* end;
  BezierCurve curve;
  // Vector* direction; // unity direction vector: it is costy to always recalculate it
  //Vector* up; // direction where up is ment to be - diffuse in space, eh?
  //Vector* traverse; // right-left 
  Uint32 nextID;
  
  Track* next;
  Track* previous;
 	
 public:
  Track ();
  
  ~Track ();
  virtual void init();

  void addPoint (Vector point);
  void addHotPoint (Vector hotPoint);
  
  Vector getPos(float t);
  
  virtual void post_enter (WorldEntity* entity);	// handle coordinate transition in here !!! (when dist < 0 or dist > lasttracklenght)
  virtual void post_leave (WorldEntity* entity);
  virtual void tick (float deltaT);
  virtual void map_camera (Location* lookat, Placement* camplc);
  virtual bool map_coords (Location* loc, Placement* plc);	// this should return true if the entity left track boundaries
};

#endif
