

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/

#include "track.h"
  float t = .0;

using namespace std;

/**
	\brief creates a null Track part
*/
Track::Track ()
{
  this->next = NULL;
  this->previous = NULL;

  curve = BezierCurve();
}

/**
	\brief removes the Track part from memory
*/
Track::~Track ()
{
  if (next != NULL)
    delete next;
  if (previous != NULL)
    delete previous;
}

void Track::init()
{
  
}

void Track::addPoint (Vector point)
{
  curve.addNode(point);

  return;
}


void Track::addHotPoint (Vector hotPoint)
{

  return;
}


Vector Track::getPos (float t)
{
  return curve.calcPos (t);
}

/**
   \brief calculate a camera Placement from a "look at"-Location
   \param lookat: the Location the camera should be centered on
   \param camplc: pointer to a buffer where the new camera Placement should be put into
   
   Theoretically you can place the camera wherever you want, but for the sake of 
   common sense I suggest that you at least try to keep the thing that should be looked
   at inside camera boundaries.
*/
void Track::map_camera (Location* lookat, Placement* camplc)
{
  t+=.0001;
  if (t> 1) t =0;
  //  Line trace(*offset, *end - *offset);
  //  float l = trace.len ();
  
  //  float r = (lookat->dist)*PI / l;
  // camplc->r = trace.r + (trace.a * ((lookat->dist-10.0) / l)) + Vector(0,0,5.0);
  camplc->pos = curve.calcPos(t) + (curve.calcDir(t)* ((lookat->dist-10.0)/t)) + Vector(-5,0,5);
				 
  Vector w(0.0,0.0,0.0);
  //  w=Vector(0,0,0) - ((trace.r + (trace.a * ((lookat->dist) / l)) - camplc->r));
  w = Vector(0,0,0) - (((curve.calcPos(t)) + ((curve.calcDir(t)) * ((lookat->dist) / t)) - camplc->pos));
  //Vector up(0.0,sin(r),cos(r)); // corrupt...
  Vector up(0.0, 0.0, 1.0);

  camplc->rot = Quaternion(w, up);

  //printf("\n------\nup vector: [%f, %f, %f]\n", up.x, up.y, up.z);
  //printf("direction: [%f, %f, %f]\n", w.x, w.y, w.z);
  //printf("quaternion: w[ %f ], v[ %f, %f, %f ]\n", camplc->w.w, camplc->w.v.x, camplc->w.v.y, camplc->w.v.z);
}

/**
   \brief calculate a Placement from a given Location
   \param loc: the Location the entity is in
   \param plc: a pointer to a buffer where the corresponding Placement should be put
   into
   \return: true if track changes - false if track stays
   
   There are no limitations to how you transform a Location into a Placement, but for 
   the sake of placement compatibility between track parts you should make sure that 
   the resulting Placement at dist == 0 is equal to the offset Vector and the Placement
   at dist == len() is equal to the end Vector. Elseway there will be ugly artifacts 
   when transfering between track parts.
*/
bool Track::map_coords (Location* loc, Placement* plc)
{
  //Line trace(*offset, *end - *offset);
  //	float l = trace.len ();
	
	/* change to the next track? */
	//	if( loc->dist > l)
	//{
	//	loc->dist -= l;
	//	loc->part = nextID;
		//FIXME: loc->track = this;
		//return true;
		//}
	
	/* this quaternion represents the rotation from start-vector (0,0,1) to the direction of
	 * the track */
	Quaternion dir(curve.calcDir(t), Vector(0,0,1)); 

	plc->pos = curve.calcPos(t) + (curve.calcDir(t) * ((loc->dist) / t)) + /*dir.apply*/(loc->pos);
	plc->rot = dir * loc->rot;
	
	return false;
}

/**
	\brief this is called when a WorldEntity enters a Track part
	\param entity: pointer to the WorldEntity in question
	
	You can do stuff like add or remove effects, do some coordinate finetuning 
	or whatever in here.
*/
void Track::post_enter (WorldEntity* entity)
{
}

/**
	\brief this is called when a WorldEntity leaves a Track part
	\param entity: pointer to the WorldEntity in question
	
	You can do stuff like add or remove effects, do some coordinate finetuning 
	or whatever in here.
*/
void Track::post_leave (WorldEntity* entity)
{
}

/**
	\brief this is called every frame
	\param deltaT: amount of time passed since the last frame in seconds
	
	Do time based or polling scripts here. 
*/
void Track::tick (float deltaT)
{
}





