

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#include "player.h"
#include "stdincl.h"
#include "collision.h"

using namespace std;


Player::Player(bool isFree) : WorldEntity(isFree)
{

  obj = new Object ("eagle.obj");
  /*
  objectList = glGenLists(1);
  glNewList (objectList, GL_COMPILE);

  glBegin(GL_TRIANGLES);
  glColor3f(1,1,1);
  glVertex3f(0,0,0.5);
  glVertex3f(-0.5,0,-1);
  glVertex3f(0.5,0,-1);

  glVertex3f(0,0,0.5);
  glVertex3f(0,0.5,-1);
  glVertex3f(0,-0.5,-1);
  glEnd();
    
  glBegin(GL_QUADS);
  glColor3f(0,0,1);
  glVertex3f(0.5,0.5,-1);
  glVertex3f(0.5,-0.5,-1);
  glVertex3f(-0.5,-0.5,-1);
  glVertex3f(-0.5,0.5,-1);
  glEnd();
  
  glEndList ();
  */
}

Player::~Player () 

{
}

void Player::post_spawn ()
{
  travel_speed = 15.0;
  velocity = Vector();
  bUp = bDown = bLeft = bRight = bAscend = bDescend = false;
  bFire = false;
  acceleration = 10.0;
  set_collision (new CollisionCluster (1.0, Vector(0,0,0)));
}

void Player::tick (float time)
{
	// movement
	move (time);
}

void Player::hit (WorldEntity* weapon, Vector loc)
{
}

void Player::destroy ()
{
}

void Player::collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags)
{
}

void Player::command (Command* cmd)
{
  //printf("Player|recieved command [%s]\n", cmd->cmd);
  if( !strcmp( cmd->cmd, "up")) bUp = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "down")) bDown = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "left")) bLeft = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "right")) bRight = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "fire")) bFire = !cmd->bUp;
}

void Player::draw ()
{ 
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  float matrix[4][4];
  
  glTranslatef(get_placement()->r.x,get_placement()->r.y,get_placement()->r.z);
  get_placement()->w.matrix (matrix);
  glMultMatrixf ((float*)matrix);
  
  glMatrixMode (GL_MODELVIEW);
  //  glRotatef (-90, 0,1,0);
  obj->draw();
  //  glCallList (objectList);

  
  
  //printf("Player@%f/%f/%f\n", get_placement()->r.x, get_placement()->r.y, get_placement()->r.z);
}

void Player::get_lookat (Location* locbuf)
{
	*locbuf = *get_location();
	//locbuf->dist += 5.0;
}

void Player::left_world ()
{
}

void Player::move (float time)
{
  Vector accel(0.0, 0.0, 0.0);
  /* FIXME: calculating the direction and orthDirection every time_slice is redundant! save it somewhere */
  Placement *pos = get_placement();
  /* calculate the direction in which the craft is heading  */
  Vector direction(0.0, 0.0, 1.0);
  direction = pos->w.apply(direction);
  Vector orthDirection(0.0, 0.0, 1.0);
  orthDirection = orthDirection.cross(direction);

  if( bUp) { accel = accel+(direction*acceleration); }
  if( bDown) { accel = accel-(direction*acceleration); }
  if( bLeft ) { accel = accel + (orthDirection*acceleration); }
  if( bRight ) { accel = accel - (orthDirection*acceleration); }
  if( bAscend ) { /* not yet implemented but just: (0,0,1)*acceleration */}
  if( bDescend) {/* FIXME */}

  Location* l = get_location();
  
  // r(t) = r(0) + v(0)*t + 1/2*a*t^2
  // r = position
  // v = velocity
  // a = acceleration

  /* this the base-speed of the player: determines how fast and how the player follows the track*/
  l->dist = l->dist + travel_speed * time;

  /* this updates the player position on the track - user interaction */
  l->pos = l->pos + accel*time;
}


















