/*!
  \file object.h
  \brief Contains the Object Class that handles 3D-Objects
*/

#ifndef _OBJECT_H
#define _OBJECT_H

#include <GL/gl.h>
#include <GL/glu.h>

#include "array.h"
#include "material.h"
#include <fstream>

using namespace std;

extern int verbose; //!< fill be removed and added again as a verbose-class


//! Class that handles 3D-Objects. it can also read them in and display them.
class Object
{
 public:
  Object ();
  Object (char* fileName);
  Object(char* fileName, float scaling);
  ~Object ();
  
  bool importFile (char* fileName);
  bool initialize (void);
  bool finalize(void);
  void draw (void);
  void draw (int groupNumber);
  void draw (char* groupName);
  int getGroupCount();

 private:
  //! Group to handle multiple Objects per obj-file
  struct Group
  {
    char* name;

    GLuint listNumber;
    Array* vertices;
    int verticesCount;
    Array* colors;
    Array* normals;
    Array* vTexture;
    int faceMode;
    int faceCount;

    int firstVertex;
    int firstNormal;
    int firstVertexTexture;

    Group* nextGroup;
  };
  
  Group* firstGroup; //!< the first of all groups.
  Group* currentGroup; //!< the currentGroup. this is the one we will work with.
  int groupCount;

  bool readingVertices;

  char* objFileName;
  char* mtlFileName;

  Material* material;
  float scaleFactor;

  ifstream* OBJ_FILE;
  ifstream* MTL_FILE;

  bool initGroup(Group* group);
  bool finalizeGroup (Group* group);
  bool cleanupGroup(Group* group);


  ///// readin ///
  bool readFromObjFile (char* fileName);
  
  bool readVertex (char* vertexString);
  bool readFace (char* faceString);
  bool readVT (char* vtString);
  bool readVertexNormal (char* normalString);
  bool readVertexTexture (char* vTextureString);
  bool readGroup (char* groupString);
  bool readMtlLib (char* matFile);
  bool readUseMtl (char* mtlString);

  bool addGLElement (char* elementString);

  void BoxObject (void);
};

#endif
