/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#include "array.h"

/**
   \brief creates a new Array
*/
Array::Array ()
{
  initializeArray ();
}

/**
   \brief deletes an Array.
   It does this by first deleting all the array-entries, and then delete the array[] itself
*/
Array::~Array()
{
  if (verbose >= 2)
    printf("deleting array\n");
  Entry* walker = firstEntry;
  Entry* last;
  while (walker != NULL)
    {
      last = walker;
      walker = walker->next;
      delete last;
    }
  if (finalized)
    delete [] array;
}

/**
   \brief initializes an Array
   the Function does this by setting up a fistEntry, and setting the entryCount.
*/
void Array::initializeArray ()
{
  if (verbose >= 2)
    printf ("crating new Array\n");
  firstEntry = new Entry;
  firstEntry->next =NULL;
  currentEntry=firstEntry;
  finalized = false;
  entryCount = 0; //0 means one entry
  return;
}

/**
   \brief finalizes an array.
   This Function creates the array, and makes it ready to be sent to the application.
*/
void Array::finalizeArray (void)
{
  if (verbose >= 3)
    printf ("Finalizing array.\n");  
  if ((array = (GLfloat*)malloc( entryCount* sizeof(GLfloat))) == NULL)
  //  if ((array = new GLfloat [entryCount]) == NULL)
    printf ("could not allocate %i data Blocks\n", entryCount);
  Entry* walker = firstEntry;
  for (int i=0; i<entryCount; i++)
    {
      array[i] = walker->value;
      walker = walker->next;
    }
  finalized = true;

  return;
}

/**
   \brief adds a new Entry to the Array
   \param entry Entry to add.
*/
void Array::addEntry (GLfloat entry)
{
  if (!finalized)
    {
      if (verbose >= 3)
	printf ("adding new Entry to Array: %f\n", entry);
      
      currentEntry->value = entry;
      currentEntry->next = new Entry;
      currentEntry = currentEntry->next;
      currentEntry->next = NULL;
      ++entryCount;
    }
  else 
    if (verbose >= 1)
      printf ("adding failed, because list has been finalized\n");
}

/**
   \brief Adds 3 entries at once (convenience)
*/
void Array::addEntry (GLfloat entry0, GLfloat entry1, GLfloat entry2)
{
  addEntry (entry0);
  addEntry (entry1);
  addEntry (entry2);
}
  
/**
   \brief Gives back the array !! MUST be executed AFTER finalize.
   \returns The created array.
*/
GLfloat* Array::getArray ()
{
  return array;
}

/**
   \returns The Count of entries in the Array
*/
int Array::getCount()
{
  return entryCount;
}

/**
   \brief Simple debug info about the Array
*/
void Array::debug ()
{
  printf ("entryCount=%i, address=%p\n", entryCount, array);
}
