/*!
  \file material.h
  \brief Contains the Material Class that handles Material for 3D-Objects.
*/

#ifndef _MATERIAL_H
#define _MATERIAL_H

extern int verbose; //!< will be obsolete soon.

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdlib.h>
#include <fstream>

//! Class to handle Materials.
class Material
{
 public:
  Material ();
  Material (char* mtlName);
  Material* addMaterial(char* mtlName);

  void init(void);
  ~Material ();


  void setName (char* mtlName);
  char* getName (void);
  void setIllum (int illum);
  void setIllum (char* illum);
  void setDiffuse (float r, float g, float b);
  void setDiffuse (char* rgb);
  void setAmbient (float r, float g, float b);
  void setAmbient (char* rgb);
  void setSpecular (float r, float g, float b);
  void setSpecular (char* rgb);
  void setShininess (float shini);
  void setShininess (char* shini);
  void setTransparency (float trans);
  void setTransparency (char* trans);

  Material* search (char* mtlName);

  bool select (void);

  Material* nextMat; //!< pointer to the Next Material of the List. NULL if no next exists.

 private:
  char name [50];
  int illumModel;
  float diffuse [4];
  float ambient [4];
  float specular [4];
  float shininess;
  float transparency;

};
#endif
