/*!
  \file array.h
  \brief Contains the Array Class that handles float arrays.
  this class creates a Array of a semi-Dynamic length.
  beware, that after finalizing the array may not be resized again.
*/

#ifndef _ARRAY_H
#define _ARRAY_H

extern int verbose; //!< will be obsolete soon

#include <GL/gl.h>
#include <GL/glu.h>
#include <fstream>


//! Array Class that handles dynamic-float arrays.
class Array
{
 public:
  Array ();
  ~Array();

  void initializeArray ();
  void finalizeArray (void);
  void addEntry (GLfloat entry);
  void addEntry(GLfloat entry0, GLfloat entry1, GLfloat entry2);
  
  GLfloat* getArray ();
  int getCount();
  void debug(void);
 private:
  struct Entry
  {
    GLfloat value;
    Entry* next;
  };

  GLfloat* array;
  int entryCount;
  bool finalized;
  Entry* firstEntry;
  Entry* currentEntry;
  
  
};

#endif
