#ifndef _OBJECT_H
#define _OBJECT_H

#include <GL/gl.h>
#include <GL/glu.h>

#include "array.h"
#include "material.h"
#include <fstream.h>


class Object
{
 public:
  Object ();
  Object (char* fileName);
  ~Object ();
  
  bool importFile (char* fileName);
  bool initialize (void);
  bool finalize(void);
  void draw (void);

  bool readFromObjFile (char* fileName);


 private:
  GLuint listNumber;
  Array* vertices;
  int verticesCount;
  Array* colors;
  Array* normals;
  char* objFileName;
  char* mtlFileName;
  int faceMode;
  bool readVertices;
  Material* material;

  ifstream* OBJ_FILE;
  ifstream* MTL_FILE;
  
  bool readVertex (char* vertexString);
  bool readFace (char* faceString);
  bool readVT (char* vtString);
  bool readVertexNormal (char* normalString);
  bool readMtlLib (char* matFile);
  bool readUseMtl (char* mtlString);

  bool addGLElement (char* elementString);
};

#endif
