#ifndef _MATERIAL_H
#define _MATERIAL_H

extern int verbose;

#include <GL/gl.h>
#include <GL/glu.h>
#include <stdlib.h>
#include <fstream>

class Material
{
 public:
  Material ();
  Material (char* mtlName);
  Material* addMaterial(char* mtlName);

  void init(void);
  ~Material ();


  void setName (char* mtlName);
  char* getName (void);
  void setIllum (int illum);
  void setIllum (char* illum);
  void setDiffuse (float r, float g, float b);
  void setDiffuse (char* rgb);
  void setAmbient (float r, float g, float b);
  void setAmbient (char* rgb);
  void setSpecular (float r, float g, float b);
  void setSpecular (char* rgb);
  void setTransparency (float trans);
  void setTransparency (char* trans);

  Material* search (char* mtlName);

  bool select (void);

  Material* nextMat;

 private:
  char name [50];
  int illumModel;
  float diffuse [4];
  float ambient [4];
  float specular [4];
  float transparency;

};
#endif
