# -helper macro to add a "doc" target with CMake build system. 
# and configure doxy.config.in to doxy.config
#
# target "doc" allows building the documentation with doxygen/dot on WIN32 and Linux
# Creates .chm windows help file if MS HTML help workshop 
# (available from http://msdn.microsoft.com/workshop/author/htmlhelp)
# is installed with its DLLs in PATH.
#
#
# Please note, that the tools, e.g.:
# doxygen, dot, latex, dvips, makeindex, gswin32, etc.
# must be in path.
#
# Note about Visual Studio Projects: 
# MSVS hast its own path environment which may differ from the shell.
# See "Menu Tools/Options/Projects/VC++ Directories" in VS 7.1
#
# author Jan Woetzel 2004-2006
# www.mip.informatik.uni-kiel.de/~jw
# Adjustments for Orxonox by Reto Grieder

FIND_PACKAGE(Doxygen QUIET)

IF (DOXYGEN_FOUND)
  # click+jump in Emacs and Visual Studio (for doxy.config) (jw)
  IF(CMAKE_BUILD_TOOL MATCHES "msdev|devenv")
    SET(DOXY_WARN_FORMAT "\"$file($line) : $text \"")
  ELSE()
    SET(DOXY_WARN_FORMAT "\"$file:$line: $text \"")
  ENDIF()
  
  # we need latex for doxygen because of the formulas
  # Orxonox doesn't
  #FIND_PACKAGE(LATEX)
  #IF    (NOT LATEX_COMPILER)
  #  MESSAGE(STATUS "latex command LATEX_COMPILER not found but usually required. You will probably get warnings and user inetraction on doxy run.")
  #ENDIF (NOT LATEX_COMPILER)
  #IF    (NOT MAKEINDEX_COMPILER)
  #  MESSAGE(STATUS "makeindex command MAKEINDEX_COMPILER not found but usually required.")
  #ENDIF (NOT MAKEINDEX_COMPILER)
  #IF    (NOT DVIPS_CONVERTER)
  #  MESSAGE(STATUS "dvips command DVIPS_CONVERTER not found but usually required.")
  #ENDIF (NOT DVIPS_CONVERTER)
  
  IF(EXISTS ${CMAKE_SOURCE_DIR}/doxy.config.in)
    CONFIGURE_FILE(${CMAKE_SOURCE_DIR}/doxy.config.in ${CMAKE_BINARY_DIR}/doxy.config @ONLY)
    # use (configured) doxy.config from (out of place) BUILD tree:
    SET(DOXY_CONFIG ${CMAKE_BINARY_DIR}/doxy.config)
  ELSE()
    MESSAGE(STATUS "Warning: Could not find dox.config.in in the root directory.")
  ENDIF()
  
  ADD_CUSTOM_TARGET(doc ${DOXYGEN_EXECUTABLE} ${DOXY_CONFIG})
  
  # create a windows help .chm file using hhc.exe
  # HTMLHelp DLL must be in path!
  # fallback: use hhw.exe interactively
  IF(WIN32)
    FIND_PACKAGE(HTMLHelp)
    IF(HTML_HELP_COMPILER)      
      SET(TMP ${CMAKE_CURRENT_BINARY_DIR}/doc/html/index.hhp)
      STRING(REGEX REPLACE "/" "\\\\" HHP_FILE ${TMP})
      ADD_CUSTOM_TARGET(chmdoc ${HTML_HELP_COMPILER} ${HHP_FILE})
      IF(NOT MSVC)
        ADD_DEPENDENCIES(chmdoc doc)
      ELSE(NOT MSVC)
        # Do not add the dependency because msvc will then always build
        # Doxygen, which is not very comforting.
      ENDIF(NOT MSVC)
    ENDIF(HTML_HELP_COMPILER)
  ENDIF (WIN32) 
ENDIF(DOXYGEN_FOUND)
