
#ifndef WORLD_H
#define WORLD_H

#include "stdincl.h"

class Track;
class WorldEntity;

class World {

 public:
  World ();
  ~World ();

	template<typename T> 
	  T* spawn(Location* loc, WorldEntity* owner);	// template to be able to spawn any derivation of WorldEntity
	template<typename T> 
	  T* spawn(Placement* plc, WorldEntity* owner);

	void time_slice (Uint32 deltaT);
	void collide ();
	void draw ();
	void update ();	// maps Locations to Placements
	void calc_camera_pos (Location* loc, Placement* plc);
	
	void unload ();
	
	void load_debug_level ();
	
 private:
 
	List<WorldEntity>* entities;
	
		// base level data
	Track* track;
	Uint32 tracklen;
	Vector* pathnodes;

};

template<typename T> T* World::spawn(Location* loc = NULL, WorldEntity* owner = NULL)
{
	Location zeroloc;
	T* entity = new T();
	entities->add ((WorldEntity*)entity, LIST_ADD_NEXT);
	if( loc == NULL)
	{
		zeroloc.dist = 0;
		zeroloc.part = 0;
		zeroloc.pos = Vector();
		zeroloc.rot = Quaternion();
		loc = &zeroloc;
	}
	entity->init (loc, owner);
	if (entity->bFree)
	{
		track[loc->part].map_coords( loc, entity->get_placement());
	}
	entity->post_spawn ();
	return entity;
}

template<typename T> T* World::spawn(Placement* plc, WorldEntity* owner = NULL)
{
	T* entity = new T();
	entities->add ((WorldEntity*)entity, LIST_ADD_NEXT);
	entity->init (plc, owner);
	if (!entity->bFree)
	{
		printf("Can't spawn unfree entity with placement\n"); 
		entities->remove( (WorldEntity*)entity, LIST_FIND_FW);
		return NULL;
	}
	entity->post_spawn ();
	return entity;
}

#endif
