

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/

#include "track.h"

using namespace std;

Track::Track ()
{
	ID = 0;
	offset = NULL;
	end = NULL;
	nextID = 0;
}

Track::Track (Uint32 number, Uint32 next, Vector* start, Vector* finish)
{
	ID = number;
	offset = start;
	end = finish;
	nextID = next;
}

Track::~Track ()
{
}

void Track::map_camera (Location* lookat, Placement* camplc)
{
printf("Track|Mapping camera: %d (%f)\n", lookat->part, lookat->dist);
	Line trace(*offset, *end - *offset);
	float l = trace.len ();
	
//	camplc->r = *offset + Vector(0,0,0.5);
//	camplc->w = Quaternion (trace.a, Vector(0,0,1));
	
	camplc->r = trace.r + (trace.a * ((lookat->dist-10.0) / l)) + Vector(0,0,5.0);
	camplc->w = Quaternion((trace.r + (trace.a * ((lookat->dist) / l)) - camplc->r), Vector(0,0,1));
	
}

bool Track::map_coords (Location* loc, Placement* plc)
{
printf("Track|Mapping coords: %d (%f)\n", loc->part, loc->dist);
	Line trace(*offset, *end - *offset);
	float l = trace.len ();
	
	if( loc->dist > l)
	{
		loc->dist -= l;
		loc->part = nextID;
		return true;
	}
	
	Quaternion dir(trace.a, Vector(0,0,1));
	
	plc->r = trace.r + (trace.a * ((loc->dist) / l)) + dir.apply(loc->pos);
	plc->w = dir * loc->rot;
	
	return false;
}

void Track::post_enter (WorldEntity* entity)
{
}

void Track::post_leave (WorldEntity* entity)
{
}

void Track::tick (float deltaT)
{
}





