

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#include "player.h"
#include "stdincl.h"
#include "collision.h"

using namespace std;


Player::Player(bool isFree) : WorldEntity(isFree)
{
}

Player::~Player () 
{
}

void Player::post_spawn ()
{
	travel_speed = 10.0;
	velocity = Vector();
	bUp = bDown = bLeft = bRight = bAscend = bDescend = false;
	bFire = false;
	acceleration = 10.0;
	set_collision (new CollisionCluster (1.0, Vector(0,0,0)));
}

void Player::tick (float time)
{
	// movement
	move (time);
}

void Player::hit (WorldEntity* weapon, Vector loc)
{
}

void Player::destroy ()
{
}

void Player::collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags)
{
}

void Player::command (Command* cmd)
{
	if( !strcmp( cmd->cmd, "up")) bUp = !cmd->bUp;
	else if( !strcmp( cmd->cmd, "down")) bDown = !cmd->bUp;
	else if( !strcmp( cmd->cmd, "left")) bLeft = !cmd->bUp;
	else if( !strcmp( cmd->cmd, "right")) bRight = !cmd->bUp;
	else if( !strcmp( cmd->cmd, "fire")) bFire = !cmd->bUp;
}

void Player::draw ()
{
	glMatrixMode(GL_MODELVIEW);
	float matrix[4][4];
  get_placement()->w.matrix (matrix);
  glLoadMatrixf ((float*)matrix);

	glTranslatef(get_placement()->r.x,get_placement()->r.y,get_placement()->r.z);
	
	glBegin(GL_TRIANGLES);
	glColor3f(1,0,0);
	glVertex3f(0,0,0);
	glColor3f(0,1,0);
	glVertex3f(-1,-0.5,0);
	glColor3f(0,0,1);
	glVertex3f(-1,+0.5,0);
	glEnd();
	
	printf("Player@%f/%f/%f\n", get_placement()->r.x, get_placement()->r.y, get_placement()->r.z);
}

void Player::get_lookat (Location* locbuf)
{
	*locbuf = *get_location();
	//locbuf->dist += 5.0;
}

void Player::left_world ()
{
}

void Player::move (float time)
{
	float xAccel, yAccel, zAccel;
	xAccel = yAccel = zAccel = 0;
	if( bUp) xAccel += acceleration;
	if( bDown) xAccel -= acceleration;
	if( bLeft) yAccel += acceleration;
	if( bRight) yAccel -= acceleration;
	if( bAscend) zAccel += acceleration;
	if( bDescend) zAccel -= acceleration;
	
	Vector accel( xAccel, yAccel, zAccel);
	
	Location* l = get_location();
	
	// r(t) = r(0) + v(0)*t + 1/2*a*t^2
	// r = position
	// v = velocity
	// a = acceleration
	
	l->pos = l->pos + velocity*time + (accel*(0.5*time*time));
	l->dist += travel_speed * time;
	
	velocity = velocity + (accel * time);
}


















