/*! 
    \file coordinates.h
    \brief Basic coordinate system definitions
*/ 

#ifndef COORDINATES_H
#define COORDINATES_H

#include "vector.h"

//! Coordinates relative to track
/**
  This identifies the position of an object on the track system
*/
typedef struct
{
  unsigned long part;   //!< ID of the track part the object is on
  float dist;           //!< The distance that has already been traveled on the track
  Vector pos;           //!< The position relative to the offset marked by the distance already covered
  Quaternion rot;         //!< The direction the object is heading (relative to track direction)
} Location;

//! Absolute coordinates
/**
  This is used to store the position of a object in the rendered coordinate system
*/
typedef struct
{
  Vector r;              //!< Absolute x/y/z coordinates
  Quaternion w;            //!< Absolute orientation
} Placement;

#endif
