/*! 
    \file camera.h
    \brief Viewpoint controlling class definitions
*/ 

#ifndef CAMERA_H
#define CAMERA_H

#include "stdincl.h"

class WorldEntity;

//! Camera
/**
 	This class controls the viewpoint from which the World is rendered. To use the Camera it has
 	to be bound to a WorldEntity which serves as the reference focus point. The Camera itself calls
 	the WorldEntity::get_lookat() and World::calc_camera_pos() functions to calculate the position it
 	currently should be in.
*/
class Camera {
 private:
 	WorldEntity* bound;		//!< the WorldEntity the Camera is bound to
 	Placement actual_place;	//!< the Camera's current position
 	Placement desired_place; //!< where the Camera should be according to calculations

	void update_desired_place ();
	
	float h;
	
 public:
  Camera ();
  ~Camera ();

	void time_slice (Uint32 deltaT);
	void apply ();
	void bind (WorldEntity* entity);
	void jump (Placement* plc);

};

#endif
