
#ifndef WORLD_ENTITY_H
#define WORLD_ENTITY_H

#include "stdincl.h"
//#include "data_tank.h"

class Vector;
class Ability;

class WorldEntity
{	
	friend class World;

 public:
  WorldEntity (bool isFree);
  ~WorldEntity ();

 	Location* get_location ();
 	Placement* get_placement ();
 	void set_collision (CollisionCluster* newhull);
 	
  //void addAbility(Ability* ability);
  //void removeAbility(Ability* ability);

	virtual void post_spawn ();
  virtual void tick (float time);
  virtual void hit (WorldEntity* weapon, Vector loc);
  virtual void destroy ();
  virtual void collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags);
 	virtual void command (Command* cmd);
  
  virtual void draw ();
  virtual void get_lookat (Location* locbuf);

	virtual void left_world ();

 private:
  bool bCollide;
  bool bDraw;
  bool bFree;		// Whether entity movement is bound to the track
  
 	WorldEntity* owner;
 	CollisionCluster* collisioncluster;
 	Placement place;
 	Location loc;

	void init( Location* spawnloc, WorldEntity* spawnowner);
	void init( Placement* spawnplc, WorldEntity* spawnowner);
};

#endif
