

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#include <iostream>

#include "world_entity.h"

#include "vector.h"

using namespace std;


/**
   \brief 
   \param v:
   \return 
*/

/**
   \brief Constructor

   This Constructor initializises the all WorldEntities. Everything, that is a part of the game-world is a child of WorldEntity. This class implements empty functions for all sort of operation a WorldEntity has to or can implement.
This is some sort of standard interface to all WorldEntities...
*/
WorldEntity::WorldEntity (bool isFree = false) : bFree(isFree)
{
	collisioncluster = NULL;
	owner = NULL;
}

WorldEntity::~WorldEntity () {}

Location* WorldEntity::getLocation ()
{
	return &loc;
}

Placement* WorldEntity::getPlacement ()
{
	return &place;
}

void WorldEntity::set_collision (CollisionCluster* newhull)
{
	if( newhull == NULL) return;
	if( collisioncluster != NULL) delete collisioncluster;
	collisioncluster = newhull;
}

/**
   \brief sets the speed of the entity, if any
   \param speed: the speed in points (openGL points) per seconds
*/
void WorldEntity::setSpeed(float speed)
{
  this->speed = speed;
}

/**
   \brief gets the speed of the entity, if any
   \return the speed in points (openGL points) per seconds
*/
float WorldEntity::getSpeed()
{
  return speed;
}

/**
   \brief sets the health of the entity
   \param health: number for the life count, normaly {0..100}
*/
void WorldEntity::setHealth(float health)
{
  this->health = health;
}

/**
   \brief gets the health of the entity
   \return number for the life count, normaly {0..100}
*/
float WorldEntity::getHealth()
{
  return health;
}

/**
   \brief this method is called every tick
   \param time: the time since start of the world

   This function is called before every repaint of the world, to update every time dependent variable of the entity. If the entity moves, it has to calculate the new position every tick here in this function. Do not use this for animations.
*/
void WorldEntity::tick(float time) 
{}

/**
   \brief the entity is painted to the screen with this function

   This is a central function of an entity: call it to let the entity painted to the screen. Just override this function with whatever you want to be drawn.
*/
void WorldEntity::draw() 
{
  cout << "WorldEntity::draw()" << endl;
}

/* virtual void WorldEntity::actionEvent(Event* event); */
/**
   \brief this function is called, when two entities collide
   \param we: the world entity, with whom it collides
   \param loc: place where the collision happens
*/
void WorldEntity::collide(WorldEntity* other, Uint32 ownhitflags, Uint32 otherhitflags) {}

/**
   \brief this function is called, when the ship is hit by a waepon
   \param weapon: the laser/rocket/shoot that hits.
   \param loc: place where it is hit

   calculate the damage depending
*/
void WorldEntity::hit(WorldEntity* weapon, Vector loc) {}

/**
   \brief this function is called, if the entity is to be destroied
   
   This can be called, if eg. something realy bad happens :)
*/
void WorldEntity::destroy() {}

void WorldEntity::init( Location* spawnloc, WorldEntity* spawnowner)
{
	loc = *spawnloc;
	owner = spawnowner;
}

void WorldEntity::init( Placement* spawnplc, WorldEntity* spawnowner)
{
	plc = *spawnplc;
	owner = spawnowner;
}
