/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#ifdef __WIN32__
#include <windows.h>
#endif

#include <iostream>
#include <cstdio>
#include <GL/glut.h>
#include <SDL/SDL.h>

#include "environment.h"
#include "world.h"
#include "input_output.h"
#include "data_tank.h"
#include "stdincl.h"
#include "player.h"
#include "npc.h"
#include "shoot_laser.h"

#include "orxonox.h"

using namespace std;


Orxonox::Orxonox () 
{
  pause = false;
}



Orxonox::~Orxonox () 
{
	Orxonox::singleton_ref = NULL;
	if( world != NULL) delete world;
	if( localinput != NULL) delete world;
	if( localcamera != NULL) delete camera;
	if( resources != NULL) delete resources;
}


/* this is a singleton class to prevent duplicates */
Orxonox* Orxonox::singleton_ref = 0;
World* Orxonox::world = 0;
bool Orxonox::pause = false;


Orxonox* Orxonox::getInstance (void)
{
  if (singleton_ref == NULL)
    singleton_ref = new Orxonox();
  return singleton_ref;
}

void Orxonox::get_config_file (int argc, char** argv)
{
	char* path;
	#ifdef __WIN32__
	path = getenv("");
	#else
	path = getenv("HOME");
	#endif
	
	if( path != NULL) strcpy (configfilename, path);
	else strcpy (configfilename, "./");
	strcat (configfilename, "/.orxonox.conf");
}

int Orxonox::init (int argc, char** argv)
{
		// parse command line
		// config file
		
	get_config_file (argc, argv);
	
		// initialize SDL
  printf("> Initializing SDL\n");
  if( SDL_Init (SDL_INIT_EVERYTHING) == -1)
  {
    printf ("Could not SDL_Init(): %s\n", SDL_GetError());
    return -1;
  }
  
  	// initialize everything
  printf("> Initializing video\n");
	if( init_video () == -1) return -1;
  printf("> Initializing sound\n");
	if( init_sound () == -1) return -1;
  printf("> Initializing input\n");
	if( init_input () == -1) return -1;
  printf("> Initializing networking\n");
	if( init_networking () == -1) return -1;
  printf("> Initializing resources\n");
	if( init_resources () == -1) return -1;
  printf("> Initializing world\n");
	if( init_world () == -1) return -1;
	
	return 0;
}

int Orxonox::init_video () 
{
  // Set video mode
  // TO DO: parse arguments for settings
  SDL_GL_SetAttribute (SDL_GL_RED_SIZE, 5);
  SDL_GL_SetAttribute (SDL_GL_GREEN_SIZE, 5);
  SDL_GL_SetAttribute (SDL_GL_BLUE_SIZE, 5);
  SDL_GL_SetAttribute (SDL_GL_DEPTH_SIZE, 16);
  
  int bpp = 16;
  int width = 640;
  int height = 480;
  Uint32 flags = SDL_OPENGL | SDL_GL_DOUBLEBUFFER;
  
  if( (screen = SDL_SetVideoMode (width, height, bpp, flags)) == NULL)
  {
    printf ("Could not SDL_SetVideoMode(%d, %d, %d, %d): %s\n", width, height, bpp, flags, SDL_GetError());
    SDL_Quit();
    return -1;
  }
  
  // Set window labeling
  // TO DO: Add version information to caption
  SDL_WM_SetCaption( "Orxonox", "Orxonox");
  
  // TO DO: Create a cool icon and use it here
  // SDL_WM_SetIcon(SDL_Surface *icon, Uint8 *mask);  

  // OpenGL stuff
  // (Is this all we initialize globally???)
  glClearColor(0.0, 0.0, 0.0, 0.0);
  glEnable(GL_DEPTH_TEST);
  glShadeModel(GL_FLAT);
  
  // create camera
  localcamera = new Camera();
  
  return 0;
}

int Orxonox::init_sound () 
{
	printf("Not yet implemented\n");
	return 0;
}

int Orxonox::init_input () 
{
	// create localinput
	localinput = new CommandNode( configfilename);
	
	return 0;
}


int Orxonox::init_networking () 
{
	printf("Not yet implemented\n");
	return 0;
}

int Orxonox::init_resources () 
{
	printf("Not yet implemented\n");
	return 0;
}

int Orxonox::init_world () 
{
	world = new World();
	
	// TO DO: replace this with a menu/intro
	world->load_debug_level();
	
	return 0;
}

void Orxonox::quitGame() 
{
	bQuitOrxonox = true;
  //cout << "finished garbage colletion, quitting..." << endl;
}
void Orxonox::mainLoop()
{
  // This is where everything is run
  while( !bQuitOrxonox)
  {
  	// Network
  	synchronize();
    // Process input
    handle_input();
    // Process time
    time_slice();
    // Process collision
    collision();
    // Draw
    display();
  }
}

void Orxonox::event_handler (SDL_Event* event)
{
	// Handle special events such as reshape, quit, focus changes
}

void Orxonox::synchronize ()
{
	// Get remote input
	// Update synchronizables
}

void Orxonox::handle_input ()
{
	// localinput
		localinput.process();
	// remoteinput
}

void Orxonox::time_slice ()
{
	Uint32 curframe = SDL_GetTicks();
	if( !pause)
	{
		world->time_slice (curframe - lastframe);
		world->update ();
		localcamera->time_slice (curframe - lastframe);
	}
	lastframe = curframe;
}

void Orxonox::collision ()
{
	world->collide ();
}

void Orxonox::display ()
{
		// clear buffer
	glClear( GL_COLOR_BUFFER_BIT, GL_DEPTH_BUFFER_BIT);
		// set camera
	localcamera->apply ();
		// draw world
	world->draw ();
		// draw HUD
		// flip buffers
	SDL_Flip( screen);
}

Camera* Orxonox::get_camera ()
{
	return localcamera;
}

Camera* Orxonox::get_world ()
{
	return world;
}

int main (int argc, char** argv) 
{  
  Orxonox *orx = Orxonox::getInstance();
  
  if( (*orx).init(argc, argv) == -1)
  {
    printf("! Orxonox initialization failed\n");
    return -1;
  }

	lastframe = SDL_GetTicks();
	
  (*orx).mainLoop();
  
  return 0;
}