/*! 
    \file world_entity.h
    \brief A base class for all objects in the world
    
    This is the base class of all objects in the game-world. If you want to have an object in the world, that can realy interact with other objects and that is also dispbayable etc. you have to extend this class and override the needed functions.
*/ 



#ifndef WORLD_ENTITY_H
#define WORLD_ENTITY_H

#include "data_tank.h"

class Vector;
class Ability;

//! WorldEntity
/**
  A base class for all objects in the world

  This is the base class of all objects in the game-world. If you want to have an object in the world, that can realy interact with other objects and that is also dispbayable etc. you have to extend this class and override the needed functions.
*/
class WorldEntity {

 public:
  WorldEntity ();
  ~WorldEntity ();


  void setPosition(Vector* position);
  Vector* getPosition();
  void setOrientation(Vector* orientation);
  Vector* getOrientation();
  void setSpawnPoint(Vector* place);
  void setSpeed(float speed);
  float getSpeed();
  void setHealth(float health);
  float getHealth();

  void addAbility(Ability* ability);
  void removeAbility(Ability* ability);

  virtual void tick(float dt);
  virtual void paint();
  /* virtual void actionEvent(Event* event); */
  virtual void collide(WorldEntity* we, Vector loc);
  virtual void hit(WorldEntity* weapon, Vector loc);
  virtual void destroy();

  virtual void entityPreEnter();
  virtual void entityPostEnter();
  virtual void entityPreQuit();
  virtual void entityPostQuit();

 

 private:
  Vector* position;    //!< position of the entity
  Vector* orientation; //!< orientation of the entity
  /* List of abilities */ 
  float health; //!< health of the entity, if any
  float speed; //!< speed of the entity if any
  /* entity can be in the air or at ground: */
  int airGround; //!< is it air or bound to the ground (ground=0, air=1)

  

};

#endif
