/**
  Class representating the game-world
  
  It contains a list of players (if multiplayer game), a list of Non-Player-Characters (nps), a list of Environment Entities. All this things together are building the orxonox-world. This class also handels the story-line (track), the world start/stop, init/uninit abilities. It is the middle point of every orxonox world.
*/

#ifndef WORLD_H
#define WORLD_H

class Player;
class NPC;
class Environment;
class WorldEntity;

template<class T> class List;



//! World Class
/**
  Class for World representation
  
  It contains a list of players (if multiplayer game), a list of Non-Player-Characters (nps), a list of Environment Entities. All this things together are building the orxonox-world. This class also handels the story-line (track), the world start/stop, init/uninit abilities. It is the middle point of every orxonox world.
*/
class World {

 public:
  World ();
  ~World ();



  float primitiveMove; //!< deprecated, do not use

  Player *localPlayer; //!< a pointer to the local player object
  Player *player1;     //!< a pointer to the second player object
  Player *player2;     //!< a pointer to the third player object 

  /*
  struct playerList {
    playerList* next;
    Player* player;
    int number;
  };
  playerList* lastPlayer;

  struct npcList {
    npcList* next;
    NPC* npc;
    int number;
  };
  npcList* lastNPC;

  struct envList {
    envList* next;
    Environment* env;
    int number;
  };
  envList* lastEnv;
  */


  void loadWorld();
  void unloadWorld();
  void pauseWorld();
  void saveGameState(char* filename);
  

  bool addPlayer(Player* player);
  bool removePlayer(Player* player);
  Player* getLocalPlayer();
  bool addNPC(NPC* npc);
  bool removeNPC(NPC* npc);
  bool addEnv(Environment* env);
  bool removeEnv(Environment* env);

  
  void drawWorld(void);
  void initEnvironement(void);
  void setWorldStep(float step);
  void updateWorld(void);
  void detectCollision(void);
  void testThaTest(void);

 private:
  float surface[120][120]; //!< deprecated: used to build a surface
  float step; //!< this is the step

  List<WorldEntity*> *playerList; //!< the list of players, usualy very short
  List<WorldEntity*> *npcList;  //!< list of non player characters (npc)
  List<WorldEntity*> *envList;  //!< list of environment objects


};

#endif
