
#ifndef WORLD_ENTITY_H
#define WORLD_ENTITY_H

#include "stdincl.h"
//#include "data_tank.h"

class Vector;
class Ability;

class WorldEntity {

 public:
  WorldEntity ();
  ~WorldEntity ();


  void setPosition(Vector* position);
  Vector* getPosition();
  void setOrientation(Vector* orientation);
  Vector* getOrientation();
  void setSpawnPoint(Vector* place);
  void setSpeed(float speed);
  float getSpeed();
  void setHealth(float health);
  float getHealth();

  void addAbility(Ability* ability);
  void removeAbility(Ability* ability);

  virtual void tick (float time);
  virtual void draw ();
  virtual void collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags);
  virtual void hit (WorldEntity* weapon, Vector loc);
  virtual void destroy ();
  virtual void command (Command* cmd);
  virtual void get_lookat (Location* locbuf);

  virtual void entityPreEnter();
  virtual void entityPostEnter();
  virtual void entityPreQuit();
  virtual void entityPostQuit();

  bool bCollide;
  bool bDraw;

 private:
 	WorldEntity* owner;
 	CollisionCluster* collisioncluster;
 	Placement place;
 	Location loc;
  /* List of abilities */ 
  float health;
  float speed;
  /* entity can be in the air or at ground: */
  int airGround;

  

};

#endif
