
#ifndef WORLD_H
#define WORLD_H

class World {

 public:
  World ();
  ~World ();

	template<class T> T* spawn<T>(Location* loc, WorldEntity* owner);	// template to be able to spawn any derivation of WorldEntity

	void time_slice (Uint32 deltaT);
	void collide ();
	void draw ();
	void update ();	// maps Locations to Placements
	void calc_camera_pos (Location* loc, Placement* plc);
	
 private:
 
	List<WorldEntity>* entities;
	
		// base level data
	Track* track;
	Uint32 tracklen;
	Vector* pathnodes;

};

#endif
