
/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#include <iostream>
#include <stdlib.h>
#include <cmath>

#include "npc.h"
#include "player.h"
#include "environment.h"
#include "shoot_laser.h"
#include "shoot_rocket.h"
#include "stdincl.h"
#include "data_tank.h"

#include "world.h"


using namespace std;


/** 
   \brief Create a new World
   
   This creates a new empty world!
*/
World::World ()
{
	entities = new List<WorldEntitites>();
}


World::~World ()
{
	delete entities;
}

template<class T> T* World::spawn<T>(Location* loc, WorldEntity* owner)
{
	T* entity = new T();
	entities->add ((WorldEntity*)entity, LIST_ADD_NEXT);
	return entity;
}

World::collide ()
{
	List<WorldEntity> *a, *b;
	WorldEntity *aobj, *bobj;
	
	a = entities->get_next();
	
	while( a != NULL)
	{
		aobj = a->get_object();
		if( aobj->bCollide && aobj->collisioncluster != NULL)
		{
			b = a->get_next();
			while( b != NULL)
			{
				bobj = b->get_object();
				if( bobj->bCollide && bobj->collisioncluster != NULL)
				{
					Uint32 ahitflg, bhitflg;
					if check_collision ( aobj->place, aobj->collisioncluster, &ahitflg, bobj->place, bobj->collisioncluster, &bhitflg);
					{
						aobj->collide (bobj, ahitflg, bhitflg);
						bobj->collide (aobj, bhitflg, ahitflg);
					}
				}
				b = b->get_next();
			}
		}
		a = a->get_next();
	}
}

void World::draw ()
{
	// draw geometry
	
	// draw entities
	List<WorldEntity> *l;
	WorldEntity* entity;
	
	l = entities->get_next();  
	while( l != NULL) 
	{ 
		entity = l->get_object();
	 	if(	entity->bDraw) entity->draw();
	  l = l->get_next();
	}
}

void World::update ()
{
}

void World::time_slice (Uint32 deltaT)
{
	List<WorldEntity> *l;
	WorldEntity* entity;
	float seconds = deltaT;
	
	seconds /= 1000;
	
	l = entities->get_next();  
	while( l != NULL) 
	{ 
		entity = l->get_object();
	 	entity->tick (seconds);
	  l = l->get_next();
	}
}