
#ifndef ORXONOX_H
#define ORXONOX_H

#include <SDL/SDL.h>

class World;

class Orxonox {

 private:
  static Orxonox* singleton_ref;
  Orxonox ();
  ~Orxonox ();
  
  static char configfilename[256];
  static World* world;
  static DataTank* resources;
  static CommandNode* localinput;
  static Camera* localcamera;
  static SDL_Surface* screen;
  
  static bool bQuitOrxonox;
  static bool pause;
	static Uint32 lastframe;

	static void get_config_file (int argc, char** argv);
	
		// main loop functions
  static void synchronize ();
  static void handle_input ();
  static void time_slice ();
  static void collision ();
  static void display ();
  
  	// subsystem initialization
  int init_video ();
  int init_sound ();
  int init_input ();
  int init_networking ();
  int init_resources ();
  int init_world ();

  static void event_handler (SDL_Event* event);
  
 public:
  static Orxonox* getInstance ();
  static void quitGame();

  int init (int argc, char** argv);
	
	Camera* get_camera();
	World* get_world();
	
  void mainLoop();
};

#endif

