

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: ...
   co-programmer: ...
*/


#include "camera.h"

using namespace std;

Camera::Camera ()
{
	bound = NULL;
	desired_place.r = Vector (0,0,0);
	desired_place.w = Rotation (0,0,0);
	actual_place.r = Vector (0,0,0);
	actual_place.w = Rotation (0,0,0);
}

Camera::~Camera ()
{
}

void Camera::time_slice (Uint32 deltaT)
{
	update_desired_place ();
}

void Camera::update_desired_place ()
{
		Orxonox *orx = Orxonox::getInstance();
		Location lookat;
		
		if( bound != NULL)
		{
			bound->get_lookat (&lookat);
			orx->get_world()->calc_camera_pos (&lookat, &desired_place);
		}
		else
		{
			desired_place.r = Vector (0,0,0);
			desired_place.w = Rotation (0,0,0); 
		}
}

void Camera::apply ()
{
	glMatrixMode (GL_PROJECTION);
		// view
		// TO DO: implement options for frustum generation
	glFrustum( -1.0,1.0,-1.0,1.0,1.5,20.0);
  	// rotation
  float matrix[16];
  actual_place.w.glmatrix (matrix);
  glLoadMatrixf (matrix);
  	// translation
  glTranslatef (actual_place.v.x, actual_place.v.y, actual_place.v.z);
  
  glMatrixMode (GL_MODELVIEW);
}

void Camera::jump (Placement* plc = NULL)
{
	if( plc == NULL)
	{
		actual_place = desired_place;
	}
	else
	{
		desired_place = *plc;
		actual_place = *plc;
	}
}

void Camera::bind (WorldEntity* entity)
{
	if( entity != NULL) bound = entity; 
}
