/*!
    \file ini_parser.h
    \brief A small ini file parser
    
    Can be used to find a defined [Section] in an ini file and get the VarName=Value entries
*/

#ifndef INI_PARSER_H
#define INI_PARSER_H

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>

#define PARSELINELENGHT 512

class IniParser {
 private:
	FILE* stream;
	bool bInSection;
	char internbuf[PARSELINELENGHT];
	
 public:
  IniParser (char* filename);
  ~IniParser ();
  
  char* get_var( char* name, char* section, char* defvalue);
	int open_file( char* name);
  int get_section( char* section);
  int next_var( char* name, char* value);
};

#endif
